/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.visitors;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.sling.api.resource.Resource;

public class SimpleFilteringResourceVisitor {
    TraversalMode mode = TraversalMode.BREADTH;
    BiConsumer<Map.Entry<String, Object>, Integer> propertyVisitor = null;
    BiConsumer<Resource, Integer> resourceVisitor = null;
    BiConsumer<Resource, Integer> leafVisitor = null;
    LinkedList<Resource> stack = new LinkedList();
    Function<String, Boolean> propertyFilter = s -> true;
    Function<Resource, Boolean> traversalFilter = r -> true;

    public void setPropertyFilter(Function<String, Boolean> filter) {
        this.propertyFilter = filter;
    }

    public final void setTraversalFilter(Function<Resource, Boolean> filter) {
        this.traversalFilter = filter;
    }

    public final void setResourceVisitor(BiConsumer<Resource, Integer> handler) {
        this.resourceVisitor = handler;
    }

    public final void setLeafVisitor(BiConsumer<Resource, Integer> handler) {
        this.leafVisitor = handler;
    }

    public final void setPropertyVisitor(BiConsumer<Map.Entry<String, Object>, Integer> handler) {
        this.propertyVisitor = handler;
    }

    public final void setBreadthFirstMode() {
        this.mode = TraversalMode.BREADTH;
    }

    public final void setDepthFirstMode() {
        this.mode = TraversalMode.DEPTH;
    }

    public void accept(Resource head) {
        if (head == null) {
            return;
        }
        this.stack.clear();
        this.stack.add(head);
        int headLevel = SimpleFilteringResourceVisitor.getDepth(head.getPath());
        block3: while (!this.stack.isEmpty()) {
            Resource res = this.stack.poll();
            int level = SimpleFilteringResourceVisitor.getDepth(res.getPath()) - headLevel;
            if (this.propertyVisitor != null) {
                res.getValueMap().entrySet().stream().filter(e -> this.propertyFilter.apply((String)e.getKey())).forEach(entry -> this.propertyVisitor.accept((Map.Entry<String, Object>)entry, level));
            }
            if (this.traversalFilter == null || this.traversalFilter.apply(res).booleanValue()) {
                if (this.resourceVisitor != null) {
                    this.resourceVisitor.accept(res, level);
                }
                switch (this.mode) {
                    case BREADTH: {
                        this.stack.addAll(SimpleFilteringResourceVisitor.toList(res.getChildren()));
                        continue block3;
                    }
                }
                this.stack.addAll(0, SimpleFilteringResourceVisitor.toList(res.getChildren()));
                continue;
            }
            if (this.leafVisitor == null) continue;
            this.leafVisitor.accept(res, level);
        }
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
    }

    public static int getDepth(String path) {
        return (int)path.chars().filter(c -> c == 47).count() - 1;
    }

    public static enum TraversalMode {
        DEPTH,
        BREADTH;

    }
}

