/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.comparisons.impl;

import com.adobe.acs.commons.version.impl.EvolutionConfig;
import com.adobe.acs.commons.wcm.comparisons.PageCompareDataLine;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;

class PageCompareDataLineImpl
implements PageCompareDataLine {
    private static final int LEN = 40;
    private final String path;
    private final String name;
    private final String value;
    private final int depth;

    PageCompareDataLineImpl(Property property, String basePath, int depth) throws RepositoryException {
        this.path = property.getPath().replace(basePath, "");
        this.name = property.getName();
        this.value = EvolutionConfig.printProperty(property);
        this.depth = depth;
    }

    PageCompareDataLineImpl(Resource resource, String basePath, int depth) {
        this.path = resource.getPath().replace(basePath, "");
        this.name = resource.getName();
        this.value = null;
        this.depth = depth;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PageCompareDataLineImpl)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PageCompareDataLineImpl other = (PageCompareDataLineImpl)obj;
        return new EqualsBuilder().append((Object)this.path, (Object)other.getPath()).append((Object)this.name, (Object)other.getName()).append((Object)this.value, (Object)other.getValueString()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(79, 11).append((Object)this.path).append((Object)this.name).append((Object)this.value).toHashCode();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getUniqueName() {
        return this.path.replace("/jcr:content", "");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValueString() {
        return this.value;
    }

    @Override
    public String getValueStringShort() {
        return StringUtils.left((String)this.value, (int)40);
    }

    @Override
    public int getDepth() {
        return this.depth;
    }
}

