/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.comparisons.impl.lines;

import com.adobe.acs.commons.wcm.comparisons.lines.Line;
import com.google.common.base.Objects;
import com.google.common.base.Optional;

class LineImpl<T>
implements Line<T> {
    private final Optional<T> left;
    private final Optional<T> right;

    static <T> Line<T> right(T rightValue) {
        return new LineImpl<Object>(null, rightValue);
    }

    static <T> Line<T> left(T leftValue) {
        return new LineImpl<Object>(leftValue, null);
    }

    static <T> Line<T> both(T leftValue, T rightValue) {
        return new LineImpl<T>(leftValue, rightValue);
    }

    private LineImpl(T left, T right) {
        this.left = Optional.fromNullable(left);
        this.right = Optional.fromNullable(right);
    }

    @Override
    public T getLeft() {
        return (T)this.left.orNull();
    }

    @Override
    public T getRight() {
        return (T)this.right.orNull();
    }

    @Override
    public Line.State getState() {
        if (!this.left.isPresent()) {
            return Line.State.ONLY_RIGHT;
        }
        if (!this.right.isPresent()) {
            return Line.State.ONLY_LEFT;
        }
        if (this.left.get().equals(this.right.get())) {
            return Line.State.EQUAL;
        }
        return Line.State.NOT_EQUAL;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("left", this.left).add("right", this.right).toString();
    }
}

