/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.comparisons.impl.lines;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.List;

class Stepper<T> {
    private final List<Serializable> ids;
    private final Iterable<T> values;
    private final Function<T, Serializable> toId;
    private int step = 0;

    Stepper(Iterable<T> steps, Function<T, Serializable> toId) {
        this.toId = toId;
        this.values = steps;
        this.ids = FluentIterable.from(steps).transform(toId).toList();
    }

    public T next() {
        Object ret = Iterables.size(this.values) > this.step ? Iterables.get(this.values, (int)this.step) : null;
        ++this.step;
        return (T)ret;
    }

    public int positionOfIdAfterCurrent(T t) {
        if (t != null) {
            Serializable searchId = (Serializable)this.toId.apply(t);
            for (int i = this.step; i < this.ids.size(); ++i) {
                if (!this.ids.get(i).equals(searchId)) continue;
                return i + 1 - this.step;
            }
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.step >= this.ids.size();
    }
}

