/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.adobe.acs.commons.wcm.PageRootProvider;
import com.adobe.acs.commons.wcm.impl.PageRootProviderConfig;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.Order;
import org.apache.sling.commons.osgi.RankedServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={PageRootProvider.class})
public class PageRootProviderMultiImpl
implements PageRootProvider {
    private static final Logger log = LoggerFactory.getLogger(PageRootProviderMultiImpl.class);
    @Reference(name="config", referenceInterface=PageRootProviderConfig.class, cardinality=ReferenceCardinality.MANDATORY_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private RankedServices<PageRootProviderConfig> configList = new RankedServices(Order.ASCENDING);

    @Override
    public Page getRootPage(Resource resource) {
        String pagePath = this.getRootPagePath(resource.getPath());
        if (pagePath != null) {
            PageManager pageManager = (PageManager)resource.getResourceResolver().adaptTo(PageManager.class);
            Page rootPage = pageManager.getPage(pagePath);
            if (rootPage == null) {
                log.debug("Page Root not found at [ {} ]", (Object)pagePath);
            } else if (!rootPage.isValid()) {
                log.debug("Page Root invalid at [ {} ]", (Object)pagePath);
            } else {
                return rootPage;
            }
        }
        return null;
    }

    @Override
    public String getRootPagePath(String resourcePath) {
        for (PageRootProviderConfig config : this.configList) {
            for (Pattern pattern : config.getPageRootPatterns()) {
                Matcher matcher = pattern.matcher(resourcePath);
                if (!matcher.find()) continue;
                String rootPath = matcher.group(1);
                log.debug("Page Root found at [ {} ]", (Object)rootPath);
                return rootPath;
            }
        }
        log.debug("Resource path does not include the configured page root path.");
        return null;
    }

    protected void bindConfig(PageRootProviderConfig config, Map<String, Object> props) {
        this.configList.bind((Object)config, props);
    }

    protected void unbindConfig(PageRootProviderConfig config, Map<String, Object> props) {
        this.configList.unbind((Object)config, props);
    }
}

