/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(metatype=false, paths={"/bin/wcm/duplicateVanityCheck"}, methods={"GET"})
public final class VanityDuplicateCheckServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(VanityDuplicateCheckServlet.class);

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            ResourceResolver resolver = request.getResourceResolver();
            String vanityPath = request.getParameter("vanityPath");
            String pagePath = request.getParameter("pagePath");
            log.debug("vanity path parameter passed is {}; page path parameter passed is {}", (Object)vanityPath, (Object)pagePath);
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            JSONWriter jsonWriter = new JSONWriter((Writer)response.getWriter());
            jsonWriter.array();
            if (StringUtils.isNotBlank((String)vanityPath)) {
                String xpath = "//element(*)[sling:vanityPath='" + vanityPath + "']";
                Iterator resources = resolver.findResources(xpath, "xpath");
                while (resources.hasNext()) {
                    Resource resource = (Resource)resources.next();
                    String path = resource.getPath();
                    if (!path.startsWith("/content") || path.equals(pagePath)) continue;
                    jsonWriter.value((Object)path);
                }
            }
            jsonWriter.endArray();
        }
        catch (JSONException e) {
            throw new ServletException("Unable to generate JSON result", (Throwable)e);
        }
    }
}

