/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.impl;

import com.adobe.acs.commons.util.QueryHelper;
import com.adobe.acs.commons.workflow.bulk.execution.BulkWorkflowEngine;
import com.adobe.acs.commons.workflow.bulk.execution.impl.ConfigResourceVisitor;
import com.adobe.acs.commons.workflow.bulk.execution.model.Config;
import com.adobe.acs.commons.workflow.bulk.execution.model.Status;
import com.adobe.acs.commons.workflow.bulk.execution.model.SubStatus;
import com.adobe.acs.commons.workflow.bulk.execution.model.Workspace;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class BulkWorkflowEngineImpl
implements BulkWorkflowEngine {
    private static final Logger log = LoggerFactory.getLogger(BulkWorkflowEngineImpl.class);
    private static final String BULK_WORKFLOW_MANAGER_PAGE_FOLDER_PATH = "/etc/acs-commons/bulk-workflow-manager";
    private static final String SERVICE_NAME = "bulk-workflow";
    private static final Map<String, Object> AUTH_INFO = Collections.singletonMap("sling.service.subservice", "bulk-workflow");
    @Reference
    private QueryHelper queryHelper;
    @Reference
    private Scheduler scheduler;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    @Override
    public void initialize(Config config) throws PersistenceException, RepositoryException {
        Workspace workspace = config.getWorkspace();
        if (workspace.isInitialized()) {
            log.warn("Refusing to re-initialize an already initialized Bulk Workflow Manager.");
        } else {
            workspace.getRunner().initialize(this.queryHelper, config);
        }
    }

    @Override
    public final void start(Config config) throws PersistenceException {
        Workspace workspace = config.getWorkspace();
        workspace.getRunner().start(workspace);
        Runnable job = workspace.getRunner().getRunnable(config);
        ScheduleOptions options = workspace.getRunner().getOptions(config);
        if (options != null) {
            this.scheduler.schedule((Object)job, options);
        } else {
            job.run();
        }
        workspace.commit();
    }

    @Override
    public void stopping(Config config) throws PersistenceException {
        Workspace workspace = config.getWorkspace();
        workspace.getRunner().stopping(workspace);
        workspace.commit();
    }

    @Override
    public void stop(Config config) throws PersistenceException {
        Workspace workspace = config.getWorkspace();
        this.scheduler.unschedule(workspace.getJobName());
        workspace.getRunner().stop(workspace);
        workspace.commit();
    }

    @Override
    public void resume(Config config) throws PersistenceException {
        this.start(config);
    }

    public void complete(Config config) throws PersistenceException {
        Workspace workspace = config.getWorkspace();
        this.scheduler.unschedule(workspace.getJobName());
        workspace.getRunner().complete(workspace);
        workspace.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected final void deactivate(Map<String, String> args) {
        try (ResourceResolver adminResourceResolver = null;){
            adminResourceResolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH_INFO);
            Resource root = adminResourceResolver.getResource(BULK_WORKFLOW_MANAGER_PAGE_FOLDER_PATH);
            if (root == null) {
                return;
            }
            ConfigResourceVisitor visitor = new ConfigResourceVisitor();
            visitor.accept(root);
            List<Resource> configs = visitor.getConfigs();
            for (Resource config : configs) {
                ModifiableValueMap properties = (ModifiableValueMap)config.getChild("workspace").adaptTo(ModifiableValueMap.class);
                if (!StringUtils.equals((String)Status.RUNNING.name(), (String)((String)properties.get("status", String.class)))) continue;
                properties.put((Object)"status", (Object)Status.STOPPED.name());
                properties.put((Object)"subStatus", (Object)SubStatus.DEACTIVATED.name());
            }
            if (root.getResourceResolver().hasChanges()) {
                root.getResourceResolver().commit();
            }
        }
    }

    protected void bindQueryHelper(QueryHelper queryHelper) {
        this.queryHelper = queryHelper;
    }

    protected void unbindQueryHelper(QueryHelper queryHelper) {
        if (this.queryHelper == queryHelper) {
            this.queryHelper = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

