/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.impl.runners;

import com.adobe.acs.commons.fam.ThrottledTaskRunner;
import com.adobe.acs.commons.workflow.bulk.execution.BulkWorkflowRunner;
import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.AbstractAEMWorkflowRunner;
import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.AbstractWorkflowRunner;
import com.adobe.acs.commons.workflow.bulk.execution.model.Config;
import com.adobe.acs.commons.workflow.bulk.execution.model.Payload;
import com.adobe.acs.commons.workflow.bulk.execution.model.Status;
import com.adobe.acs.commons.workflow.bulk.execution.model.Workspace;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.model.WorkflowModel;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.Queue;
import org.apache.sling.event.jobs.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={BulkWorkflowRunner.class})
public class AEMTransientWorkflowRunnerImpl
extends AbstractAEMWorkflowRunner
implements BulkWorkflowRunner {
    private static final Logger log = LoggerFactory.getLogger(AEMTransientWorkflowRunnerImpl.class);
    private static final String JOB_QUEUE_NAME = "Granite Workflow Queue";
    @Reference
    private WorkflowService workflowService;
    @Reference
    private Scheduler scheduler;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private ThrottledTaskRunner throttledTaskRunner;
    @Reference
    private JobManager jobManager;

    @Override
    public Runnable getRunnable(Config config) {
        return new AEMTransientWorkflowRunnable(config, this.scheduler, this.resourceResolverFactory, this.workflowService, this.throttledTaskRunner, this.jobManager);
    }

    @Override
    public ScheduleOptions getOptions(Config config) {
        ScheduleOptions options = this.scheduler.NOW(-1, (long)config.getInterval());
        options.canRunConcurrently(false);
        options.onLeaderOnly(true);
        options.name(config.getWorkspace().getJobName());
        return options;
    }

    @Override
    public void complete(Workspace workspace, Payload payload) throws Exception {
        super.complete(workspace, payload);
    }

    @Override
    public void forceTerminate(Workspace workspace, Payload payload) throws Exception {
        log.info("Cannot force terminate Transient Workflow for [ {} ]", (Object)payload.getPayloadPath());
    }

    protected void bindWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    protected void unbindWorkflowService(WorkflowService workflowService) {
        if (this.workflowService == workflowService) {
            this.workflowService = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindThrottledTaskRunner(ThrottledTaskRunner throttledTaskRunner) {
        this.throttledTaskRunner = throttledTaskRunner;
    }

    protected void unbindThrottledTaskRunner(ThrottledTaskRunner throttledTaskRunner) {
        if (this.throttledTaskRunner == throttledTaskRunner) {
            this.throttledTaskRunner = null;
        }
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }

    private class AEMTransientWorkflowRunnable
    implements Runnable {
        private final ResourceResolverFactory resourceResolverFactory;
        private final ThrottledTaskRunner throttledTaskRunner;
        private final WorkflowService workflowService;
        private final Scheduler scheduler;
        private final JobManager jobManager;
        private String configPath;
        private String jobName;

        public AEMTransientWorkflowRunnable(Config config, Scheduler scheduler, ResourceResolverFactory resourceResolverFactory, WorkflowService workflowService, ThrottledTaskRunner throttledTaskRunner, JobManager jobManager) {
            this.configPath = config.getPath();
            this.jobName = config.getWorkspace().getJobName();
            this.resourceResolverFactory = resourceResolverFactory;
            this.workflowService = workflowService;
            this.throttledTaskRunner = throttledTaskRunner;
            this.scheduler = scheduler;
            this.jobManager = jobManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.debug("Running Bulk AEM Transient Workflow job [ {} ]", (Object)this.jobName);
            ResourceResolver serviceResourceResolver = null;
            Resource configResource = null;
            Config config = null;
            Workspace workspace = null;
            try {
                serviceResourceResolver = this.resourceResolverFactory.getServiceResourceResolver(AbstractWorkflowRunner.AUTH_INFO);
                configResource = serviceResourceResolver.getResource(this.configPath);
                if (configResource != null) {
                    config = (Config)configResource.adaptTo(Config.class);
                }
                if (config == null) {
                    log.error("Bulk workflow process resource [ {} ] could not be found. Removing periodic job.", (Object)this.configPath);
                    this.scheduler.unschedule(this.jobName);
                } else {
                    workspace = config.getWorkspace();
                    if (workspace.isStopped() || workspace.isStopping()) {
                        AEMTransientWorkflowRunnerImpl.this.unscheduleJob(this.scheduler, this.jobName, configResource, workspace);
                        AEMTransientWorkflowRunnerImpl.this.stop(workspace);
                        return;
                    }
                    List<Payload> priorActivePayloads = workspace.getActivePayloads();
                    ArrayList<Payload> currentActivePayloads = new ArrayList<Payload>();
                    long capacity = this.getCapacity(config);
                    log.debug("Transient workflow capacity of [ {} ] for batch size [ {} ]", (Object)capacity, (Object)config.getBatchSize());
                    int complete = 0;
                    for (Payload payload : priorActivePayloads) {
                        if ((long)complete++ >= capacity) break;
                        log.trace("Marked [ {} ] as complete", (Object)payload.getPayloadPath());
                        AEMTransientWorkflowRunnerImpl.this.complete(workspace, payload);
                    }
                    WorkflowSession workflowSession = this.workflowService.getWorkflowSession((Session)serviceResourceResolver.adaptTo(Session.class));
                    WorkflowModel workflowModel = workflowSession.getModel(config.getWorkflowModelId());
                    boolean dirty = false;
                    while (capacity > 0L) {
                        Payload payload;
                        if (config.isAutoThrottle()) {
                            this.throttledTaskRunner.waitForLowCpuAndLowMemory();
                        }
                        if ((payload = AEMTransientWorkflowRunnerImpl.this.onboardNextPayload(workspace)) == null) break;
                        log.debug("Onboarding payload w/ Transient WF [ {} ~> {} ]", (Object)payload.getPath(), (Object)payload.getPayloadPath());
                        workflowSession.startWorkflow(workflowModel, workflowSession.newWorkflowData("JCR_PATH", (Object)payload.getPayloadPath()));
                        payload.setStatus(Status.RUNNING);
                        currentActivePayloads.add(payload);
                        --capacity;
                        dirty = true;
                    }
                    AEMTransientWorkflowRunnerImpl.this.cleanupActivePayloadGroups(workspace);
                    if (!dirty && currentActivePayloads.size() == 0) {
                        log.debug("No more payloads found to process. No more work to be done.");
                        AEMTransientWorkflowRunnerImpl.this.complete(workspace);
                        AEMTransientWorkflowRunnerImpl.this.unscheduleJob(this.scheduler, this.jobName, configResource, workspace);
                        log.info("Completed Bulk Workflow execution for [ {} ]", (Object)config.getPath());
                    }
                    workspace.commit();
                }
            }
            catch (Exception e) {
                String workspacePath = workspace != null ? workspace.getPath() : "unknown";
                log.error("Error processing periodic execution for job [ {} ] for workspace [ {} ]", (Object)new String[]{this.jobName, workspacePath}, (Object)e);
                AEMTransientWorkflowRunnerImpl.this.unscheduleJob(this.scheduler, this.jobName, configResource, workspace);
                try {
                    AEMTransientWorkflowRunnerImpl.this.stop(workspace);
                }
                catch (PersistenceException e1) {
                    log.error("Unable to mark this workspace [ {} ] as stopped.", (Object)workspacePath, (Object)e1);
                }
            }
            finally {
                if (serviceResourceResolver != null) {
                    serviceResourceResolver.close();
                }
            }
        }

        private long getCapacity(Config config) {
            Queue queue = this.jobManager.getQueue(AEMTransientWorkflowRunnerImpl.JOB_QUEUE_NAME);
            if (queue != null) {
                Statistics statistics = queue.getStatistics();
                return (long)config.getBatchSize() - statistics.getNumberOfJobs();
            }
            log.warn("Could not locate Job Queue named [ {} ] - this often happens on first run when no jobs have been added to the queue.", (Object)AEMTransientWorkflowRunnerImpl.JOB_QUEUE_NAME);
            return config.getBatchSize();
        }
    }
}

