/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.impl.runners;

import com.adobe.acs.commons.fam.ThrottledTaskRunner;
import com.adobe.acs.commons.workflow.bulk.execution.BulkWorkflowRunner;
import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.AbstractWorkflowRunner;
import com.adobe.acs.commons.workflow.bulk.execution.model.Config;
import com.adobe.acs.commons.workflow.bulk.execution.model.Payload;
import com.adobe.acs.commons.workflow.bulk.execution.model.PayloadGroup;
import com.adobe.acs.commons.workflow.bulk.execution.model.Status;
import com.adobe.acs.commons.workflow.bulk.execution.model.Workspace;
import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowModel;
import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowRunner;
import com.day.cq.workflow.WorkflowException;
import java.util.List;
import javax.jcr.Session;
import org.apache.commons.collections.ListUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class SyntheticWorkflowRunnerImpl
extends AbstractWorkflowRunner
implements BulkWorkflowRunner {
    private static final Logger log = LoggerFactory.getLogger(SyntheticWorkflowRunnerImpl.class);
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Scheduler scheduler;
    @Reference
    private SyntheticWorkflowRunner swr;
    @Reference
    private ThrottledTaskRunner throttledTaskRunner;

    @Override
    public final Runnable getRunnable(Config config) {
        return new SyntheticWorkflowRunnable(config, this.scheduler, this.resourceResolverFactory, this.swr, this.throttledTaskRunner);
    }

    @Override
    public ScheduleOptions getOptions(Config config) {
        ScheduleOptions options = this.scheduler.NOW();
        options.canRunConcurrently(false);
        options.onLeaderOnly(true);
        options.name(config.getWorkspace().getJobName());
        return options;
    }

    @Override
    public void forceTerminate(Workspace workspace, Payload payload) throws PersistenceException {
        workspace.setStatus(Status.FORCE_TERMINATED);
    }

    @Override
    public void complete(Workspace workspace, Payload payload) throws Exception {
        super.complete(workspace, payload);
        payload.setStatus(Status.COMPLETED);
    }

    @Override
    public void run(Workspace workspace, Payload payload) {
        super.run(workspace, payload);
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    protected void bindSwr(SyntheticWorkflowRunner syntheticWorkflowRunner) {
        this.swr = syntheticWorkflowRunner;
    }

    protected void unbindSwr(SyntheticWorkflowRunner syntheticWorkflowRunner) {
        if (this.swr == syntheticWorkflowRunner) {
            this.swr = null;
        }
    }

    protected void bindThrottledTaskRunner(ThrottledTaskRunner throttledTaskRunner) {
        this.throttledTaskRunner = throttledTaskRunner;
    }

    protected void unbindThrottledTaskRunner(ThrottledTaskRunner throttledTaskRunner) {
        if (this.throttledTaskRunner == throttledTaskRunner) {
            this.throttledTaskRunner = null;
        }
    }

    private class SyntheticWorkflowRunnable
    implements Runnable {
        private final ResourceResolverFactory resourceResolverFactory;
        private final SyntheticWorkflowRunner syntheticWorkflowRunner;
        private final ThrottledTaskRunner throttledTaskRunner;
        private final Scheduler scheduler;
        private String configPath;

        public SyntheticWorkflowRunnable(Config config, Scheduler scheduler, ResourceResolverFactory resourceResolverFactory, SyntheticWorkflowRunner syntheticWorkflowRunner, ThrottledTaskRunner throttledTaskRunner) {
            this.configPath = config.getPath();
            this.resourceResolverFactory = resourceResolverFactory;
            this.syntheticWorkflowRunner = syntheticWorkflowRunner;
            this.throttledTaskRunner = throttledTaskRunner;
            this.scheduler = scheduler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ResourceResolver serviceResourceResolver = null;
            long start = System.currentTimeMillis();
            int total = 0;
            boolean stopped = false;
            try {
                serviceResourceResolver = this.resourceResolverFactory.getServiceResourceResolver(AbstractWorkflowRunner.AUTH_INFO);
                Resource configResource = serviceResourceResolver.getResource(this.configPath);
                Config config = (Config)configResource.adaptTo(Config.class);
                Workspace workspace = config.getWorkspace();
                if (workspace.isStopped()) {
                    return;
                }
                try {
                    SyntheticWorkflowModel model = this.syntheticWorkflowRunner.getSyntheticWorkflowModel(serviceResourceResolver, config.getWorkflowModelId(), true);
                    if (config.isUserEventData()) {
                        ((Session)serviceResourceResolver.adaptTo(Session.class)).getWorkspace().getObservationManager().setUserData(config.getUserEventData());
                        log.debug("Set JCR Sessions user-event-data to [ {} ]", (Object)config.getUserEventData());
                    }
                    PayloadGroup payloadGroup = null;
                    if (workspace.getActivePayloadGroups().size() > 0) {
                        payloadGroup = workspace.getActivePayloadGroups().get(0);
                    }
                    while (payloadGroup != null) {
                        List<Payload> payloads = workspace.getActivePayloads();
                        if (payloads.size() == 0 && (payloadGroup = this.onboardNextPayloadGroup(workspace, payloadGroup)) != null) {
                            payloads = this.onboardNextPayloads(workspace, payloadGroup);
                        }
                        if (payloads == null || payloads.size() == 0) break;
                        for (Payload payload : payloads) {
                            if (workspace.isStopping() || workspace.isStopped()) {
                                SyntheticWorkflowRunnerImpl.this.stop(workspace);
                                stopped = true;
                                break;
                            }
                            try {
                                if (config.isAutoThrottle()) {
                                    this.throttledTaskRunner.waitForLowCpuAndLowMemory();
                                }
                                long processStart = System.currentTimeMillis();
                                SyntheticWorkflowRunnerImpl.this.swr.execute(serviceResourceResolver, payload.getPayloadPath(), model, false, false);
                                SyntheticWorkflowRunnerImpl.this.complete(workspace, payload);
                                log.info("Processed [ {} ] in {} ms", (Object)payload.getPayloadPath(), (Object)(System.currentTimeMillis() - processStart));
                            }
                            catch (WorkflowException e) {
                                SyntheticWorkflowRunnerImpl.this.fail(workspace, payload);
                                log.warn("Synthetic Workflow could not process [ {} ]", (Object)payload.getPath(), (Object)e);
                            }
                            catch (Exception e) {
                                log.warn("Complete call on [ {} ] failed", (Object)payload.getPath(), (Object)e);
                                SyntheticWorkflowRunnerImpl.this.fail(workspace, payload);
                            }
                            ++total;
                        }
                        workspace.commit();
                        if (!stopped) continue;
                        log.info("Bulk Synthetic Workflow run has been stopped.");
                        break;
                    }
                    if (!stopped) {
                        SyntheticWorkflowRunnerImpl.this.complete(workspace);
                    }
                    log.info("Grand total of [ {} ] payloads saved in {} ms", (Object)total, (Object)(System.currentTimeMillis() - start));
                }
                catch (Exception e) {
                    log.error("Error processing Bulk Synthetic Workflow execution.", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error("Error processing Bulk Synthetic Workflow execution.", (Throwable)e);
            }
            finally {
                if (serviceResourceResolver != null) {
                    serviceResourceResolver.close();
                }
            }
        }

        private PayloadGroup onboardNextPayloadGroup(Workspace workspace, PayloadGroup currentPayloadGroup) throws PersistenceException {
            PayloadGroup nextPayloadGroup = currentPayloadGroup.getNextPayloadGroup();
            workspace.removeActivePayloadGroup(currentPayloadGroup);
            if (nextPayloadGroup != null) {
                workspace.addActivePayloadGroup(nextPayloadGroup);
            }
            return nextPayloadGroup;
        }

        private List<Payload> onboardNextPayloads(Workspace workspace, PayloadGroup payloadGroup) throws PersistenceException {
            if (payloadGroup == null) {
                return ListUtils.EMPTY_LIST;
            }
            List<Payload> payloads = payloadGroup.getPayloads();
            if (payloads.size() > 0) {
                workspace.addActivePayloads(payloads);
            }
            return payloads;
        }
    }
}

