/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.impl.servlets;

import com.adobe.acs.commons.workflow.bulk.execution.BulkWorkflowEngine;
import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.AEMTransientWorkflowRunnerImpl;
import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.AEMWorkflowRunnerImpl;
import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.FastActionManagerRunnerImpl;
import com.adobe.acs.commons.workflow.bulk.execution.impl.servlets.JSONErrorUtil;
import com.adobe.acs.commons.workflow.bulk.execution.model.Config;
import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"POST"}, resourceTypes={"acs-commons/components/utilities/bulk-workflow-manager"}, selectors={"start"}, extensions={"json"})
public class StartServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(StartServlet.class);
    @Reference
    private BulkWorkflowEngine bulkWorkflowEngine;

    protected final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            JSONObject params = new JSONObject(request.getParameter("params"));
            ModifiableValueMap properties = (ModifiableValueMap)request.getResource().adaptTo(ModifiableValueMap.class);
            properties.put((Object)"runnerType", (Object)params.getString("runnerType"));
            properties.put((Object)"queryType", (Object)params.getString("queryType"));
            properties.put((Object)"queryStatement", (Object)params.getString("queryStatement"));
            properties.put((Object)"relativePath", (Object)StringUtils.removeStart((String)params.optString("relativePath", ""), (String)"/"));
            properties.put((Object)"workflowModel", (Object)params.getString("workflowModelId"));
            properties.put((Object)"interval", (Object)params.optInt("interval", 10));
            properties.put((Object)"timeout", (Object)params.optInt("timeout", 30));
            properties.put((Object)"throttle", (Object)params.optInt("throttle", 10));
            properties.put((Object)"retryCount", (Object)params.optInt("retryCount", 0));
            properties.put((Object)"batchSize", (Object)params.optInt("batchSize", 10));
            String userEventData = params.optString("userEventData", null);
            if (userEventData != null && !userEventData.isEmpty()) {
                properties.put((Object)"userEventData", (Object)userEventData);
            }
            properties.put((Object)"purgeWorkflow", (Object)params.optBoolean("purgeWorkflow", false));
            properties.put((Object)"autoThrottle", (Object)params.optBoolean("autoThrottle", true));
            if (AEMWorkflowRunnerImpl.class.getName().equals(properties.get("runnerType", String.class)) && this.isTransient(request.getResourceResolver(), (String)properties.get("workflowModel", String.class))) {
                properties.put((Object)"runnerType", (Object)AEMTransientWorkflowRunnerImpl.class.getName());
            }
            if (FastActionManagerRunnerImpl.class.getName().equals(properties.get("runnerType", (Object)"")) && (Integer)properties.get("retryCount", (Object)0) > 0) {
                properties.put((Object)"batchSize", (Object)1);
            }
            request.getResourceResolver().commit();
            Config config = (Config)request.getResource().adaptTo(Config.class);
            this.bulkWorkflowEngine.initialize(config);
            this.bulkWorkflowEngine.start(config);
            response.sendRedirect(request.getResourceResolver().map((HttpServletRequest)request, request.getResource().getPath()) + ".status.json");
        }
        catch (JSONException e) {
            log.error("Could not parse HTTP Request params: {}", (Throwable)e);
            JSONErrorUtil.sendJSONError(response, 500, "Could not initialize Bulk Workflow due to invalid parameters. Please review the form and try again.", e.getMessage());
        }
        catch (RepositoryException e) {
            log.error("Could not initialize Bulk Workflow: {}", (Throwable)e);
            JSONErrorUtil.sendJSONError(response, 500, "Could not initialize Bulk Workflow.", e.getMessage());
        }
        catch (IllegalArgumentException e) {
            log.warn("Could not initialize Bulk Workflow due to invalid arguments: {}", (Throwable)e);
            JSONErrorUtil.sendJSONError(response, 500, "Could not initialize Bulk Workflow due to invalid arguments.", e.getMessage());
        }
        catch (Exception e) {
            log.error("Could not initialize Bulk Workflow due to unexpected error: {}", (Throwable)e);
            JSONErrorUtil.sendJSONError(response, 500, "Could not start Bulk Workflow.", e.getMessage());
        }
    }

    private boolean isTransient(ResourceResolver resourceResolver, String workflowModelId) {
        Resource resource = resourceResolver.getResource(workflowModelId).getParent();
        return (Boolean)resource.getValueMap().get("transient", (Object)false);
    }

    protected void bindBulkWorkflowEngine(BulkWorkflowEngine bulkWorkflowEngine) {
        this.bulkWorkflowEngine = bulkWorkflowEngine;
    }

    protected void unbindBulkWorkflowEngine(BulkWorkflowEngine bulkWorkflowEngine) {
        if (this.bulkWorkflowEngine == bulkWorkflowEngine) {
            this.bulkWorkflowEngine = null;
        }
    }
}

