/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.impl.servlets;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.ActionManagerFactory;
import com.adobe.acs.commons.fam.impl.ThrottledTaskRunnerStats;
import com.adobe.acs.commons.workflow.bulk.execution.impl.runners.AEMWorkflowRunnerImpl;
import com.adobe.acs.commons.workflow.bulk.execution.impl.servlets.JSONErrorUtil;
import com.adobe.acs.commons.workflow.bulk.execution.model.Config;
import com.adobe.acs.commons.workflow.bulk.execution.model.Failure;
import com.adobe.acs.commons.workflow.bulk.execution.model.Payload;
import com.adobe.acs.commons.workflow.bulk.execution.model.Status;
import com.adobe.acs.commons.workflow.bulk.execution.model.Workspace;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.management.InstanceNotFoundException;
import javax.management.ReflectionException;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"GET"}, resourceTypes={"acs-commons/components/utilities/bulk-workflow-manager"}, selectors={"status"}, extensions={"json"})
public class StatusServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(StatusServlet.class);
    private static final int DECIMAL_TO_PERCENT = 100;
    @Reference
    private ThrottledTaskRunnerStats ttrs;
    @Reference
    private ActionManagerFactory actionManagerFactory;

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss aaa");
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        Config config = (Config)request.getResource().adaptTo(Config.class);
        Workspace workspace = config.getWorkspace();
        JSONObject json = new JSONObject();
        try {
            ActionManager actionManager;
            json.put("initialized", workspace.isInitialized());
            json.put("status", (Object)workspace.getStatus());
            if (workspace.getSubStatus() != null) {
                json.put("subStatus", (Object)workspace.getSubStatus());
            }
            json.put("runnerType", (Object)config.getRunnerType());
            json.put("queryType", (Object)config.getQueryType());
            json.put("queryStatement", (Object)config.getQueryStatement());
            json.put("workflowModel", (Object)StringUtils.removeEnd((String)config.getWorkflowModelId(), (String)"/jcr:content/model"));
            json.put("batchSize", config.getBatchSize());
            json.put("autoThrottle", config.isAutoThrottle());
            json.put("purgeWorkflow", config.isPurgeWorkflow());
            json.put("interval", config.getInterval());
            json.put("retryCount", config.getRetryCount());
            json.put("timeout", config.getTimeout());
            json.put("throttle", config.getThrottle());
            json.put("message", (Object)workspace.getMessage());
            if (config.isUserEventData()) {
                json.put("userEventData", (Object)config.getUserEventData());
            }
            if ((actionManager = this.actionManagerFactory.getActionManager(workspace.getActionManagerName())) != null && !Status.COMPLETED.equals((Object)workspace.getStatus())) {
                this.addActionManagerTrackedCounts(workspace.getActionManagerName(), json);
                for (com.adobe.acs.commons.fam.Failure failure : actionManager.getFailureList()) {
                    JSONObject failureJSON = new JSONObject();
                    failureJSON.put("payloadPath", (Object)failure.getNodePath());
                    failureJSON.put("failedAt", (Object)sdf.format(failure.getTime().getTime()));
                    json.accumulate("failures", (Object)failureJSON);
                }
            } else {
                this.addWorkspaceTrackedCounts(workspace, json);
                for (Failure failure : workspace.getFailures()) {
                    json.accumulate("failures", (Object)failure.toJSON());
                }
            }
            if (workspace.getStartedAt() != null) {
                json.put("startedAt", (Object)sdf.format(workspace.getStartedAt().getTime()));
                json.put("timeTakenInMillis", Calendar.getInstance().getTime().getTime() - workspace.getStartedAt().getTime().getTime());
            }
            if (workspace.getStoppedAt() != null) {
                json.put("stoppedAt", (Object)sdf.format(workspace.getStoppedAt().getTime()));
                json.put("timeTakenInMillis", workspace.getStoppedAt().getTime().getTime() - workspace.getStartedAt().getTime().getTime());
            }
            if (workspace.getCompletedAt() != null) {
                json.put("completedAt", (Object)sdf.format(workspace.getCompletedAt().getTime()));
                json.put("timeTakenInMillis", workspace.getCompletedAt().getTime().getTime() - workspace.getStartedAt().getTime().getTime());
            }
            if (AEMWorkflowRunnerImpl.class.getName().equals(config.getRunnerType())) {
                for (Payload payload : config.getWorkspace().getActivePayloads()) {
                    json.accumulate("activePayloads", (Object)payload.toJSON());
                }
            }
            json.put("systemStats", (Object)this.getSystemStats());
            response.getWriter().write(json.toString());
        }
        catch (JSONException e) {
            log.error("Could not collect Bulk Workflow status due to: {}", (Throwable)e);
            JSONErrorUtil.sendJSONError(response, 500, "Could not collect Bulk Workflow status.", e.getMessage());
        }
    }

    private void addActionManagerTrackedCounts(String name, JSONObject json) throws JSONException {
        ActionManager actionManager = this.actionManagerFactory.getActionManager(name);
        int failureCount = actionManager.getErrorCount();
        int completeCount = actionManager.getSuccessCount();
        int totalCount = actionManager.getAddedCount();
        int remainingCount = actionManager.getRemainingCount();
        json.put("totalCount", totalCount);
        json.put("completeCount", completeCount);
        json.put("remainingCount", remainingCount);
        json.put("failCount", failureCount);
        json.put("percentComplete", Math.round((float)(totalCount - remainingCount) / ((float)totalCount * 1.0f) * 100.0f));
    }

    private void addWorkspaceTrackedCounts(Workspace workspace, JSONObject json) throws JSONException {
        int remainingCount = workspace.getTotalCount() - (workspace.getCompleteCount() + workspace.getFailCount());
        json.put("totalCount", workspace.getTotalCount());
        json.put("completeCount", workspace.getCompleteCount());
        json.put("remainingCount", remainingCount);
        json.put("failCount", workspace.getFailCount());
        json.put("percentComplete", Math.round((float)(workspace.getTotalCount() - remainingCount) / ((float)workspace.getTotalCount() * 1.0f) * 100.0f));
    }

    private JSONObject getSystemStats() throws JSONException {
        JSONObject json = new JSONObject();
        try {
            json.put("cpu", (Object)MessageFormat.format("{0,number,#%}", this.ttrs.getCpuLevel()));
        }
        catch (InstanceNotFoundException e) {
            log.error("Could not collect CPU stats", (Throwable)e);
            json.put("cpu", -1);
        }
        catch (ReflectionException e) {
            log.error("Could not collect CPU stats", (Throwable)e);
            json.put("cpu", -1);
        }
        json.put("mem", (Object)MessageFormat.format("{0,number,#%}", this.ttrs.getMemoryUsage()));
        json.put("maxCpu", (Object)MessageFormat.format("{0,number,#%}", this.ttrs.getMaxCpu()));
        json.put("maxMem", (Object)MessageFormat.format("{0,number,#%}", this.ttrs.getMaxHeap()));
        return json;
    }

    protected void bindTtrs(ThrottledTaskRunnerStats throttledTaskRunnerStats) {
        this.ttrs = throttledTaskRunnerStats;
    }

    protected void unbindTtrs(ThrottledTaskRunnerStats throttledTaskRunnerStats) {
        if (this.ttrs == throttledTaskRunnerStats) {
            this.ttrs = null;
        }
    }

    protected void bindActionManagerFactory(ActionManagerFactory actionManagerFactory) {
        this.actionManagerFactory = actionManagerFactory;
    }

    protected void unbindActionManagerFactory(ActionManagerFactory actionManagerFactory) {
        if (this.actionManagerFactory == actionManagerFactory) {
            this.actionManagerFactory = null;
        }
    }
}

