/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.twitter.impl;

import com.adobe.acs.commons.twitter.TwitterClient;
import com.adobe.acs.commons.twitter.impl.TwitterClientImpl;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;

@Component(metatype=true, label="ACS AEM Commons - Twitter Client Adapter Factory", description="Adapter Factory to generate TwitterClient objects.")
@Service
@Properties(value={@Property(name="adaptables", value={"com.day.cq.wcm.api.Page", "com.day.cq.wcm.webservicesupport.Configuration"}, propertyPrivate=true), @Property(name="adapters", value={"twitter4j.Twitter", "com.adobe.acs.commons.twitter.TwitterClient"}, propertyPrivate=true)})
public class TwitterAdapterFactory
implements AdapterFactory {
    private static final String CLOUD_SERVICE_NAME = "twitterconnect";
    private static final Logger log = LoggerFactory.getLogger(TwitterAdapterFactory.class);
    private static final boolean DEFAULT_USE_SSL = true;
    @Property(label="HTTP Proxy Host", description="HTTP Proxy Host, leave blank for none")
    private static final String PROP_HTTP_PROXY_HOST = "http.proxy.host";
    @Property(label="HTTP Proxy Port", description="HTTP Proxy Port, leave 0 for none", intValue={0})
    private static final String PROP_HTTP_PROXY_PORT = "http.proxy.port";
    @Property(label="Use SSL", description="Use SSL Connections", boolValue={true})
    private static final String PROP_USE_SSL = "use.ssl";
    private TwitterFactory factory;
    private String httpProxyHost;
    private int httpProxyPort;
    private boolean useSsl;

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        TwitterClient client = null;
        if (adaptable instanceof Page) {
            client = this.createTwitterClientFromPage((Page)adaptable);
        } else if (adaptable instanceof com.day.cq.wcm.webservicesupport.Configuration) {
            client = this.createTwitterClientFromConfiguration((com.day.cq.wcm.webservicesupport.Configuration)adaptable);
        }
        if (client != null) {
            if (type == TwitterClient.class) {
                return (AdapterType)client;
            }
            if (type == Twitter.class) {
                return (AdapterType)client.getTwitter();
            }
        }
        return null;
    }

    private Configuration buildConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.setUseSSL(this.useSsl);
        builder.setJSONStoreEnabled(true);
        builder.setApplicationOnlyAuthEnabled(true);
        if (StringUtils.isNotBlank((String)this.httpProxyHost) && this.httpProxyPort > 0) {
            builder.setHttpProxyHost(this.httpProxyHost);
            builder.setHttpProxyPort(this.httpProxyPort);
        }
        return builder.build();
    }

    private TwitterClient createTwitterClientFromConfiguration(com.day.cq.wcm.webservicesupport.Configuration config) {
        Resource oauthConfig = (Resource)config.getContentResource().listChildren().next();
        ValueMap oauthProps = oauthConfig.getValueMap();
        String consumerKey = (String)oauthProps.get("oauth.client.id", String.class);
        String consumerSecret = (String)oauthProps.get("oauth.client.secret", String.class);
        if (consumerKey != null && consumerSecret != null) {
            Twitter twitter = this.getInstance();
            log.debug("Creating client for key {}.", (Object)consumerKey);
            twitter.setOAuthConsumer(consumerKey, consumerSecret);
            try {
                twitter.getOAuth2Token();
                return new TwitterClientImpl(twitter, config);
            }
            catch (TwitterException e) {
                log.error("Unable to create Twitter client.", (Throwable)e);
                return null;
            }
        }
        log.warn("Key or Secret missing for configuration {}", (Object)config.getPath());
        return null;
    }

    @VisibleForTesting
    Twitter getInstance() {
        return this.factory.getInstance();
    }

    private TwitterClient createTwitterClientFromPage(Page page) {
        com.day.cq.wcm.webservicesupport.Configuration config = this.findTwitterConfiguration(page);
        if (config != null) {
            return this.createTwitterClientFromConfiguration(config);
        }
        return null;
    }

    private com.day.cq.wcm.webservicesupport.Configuration findTwitterConfiguration(Page page) {
        ConfigurationManager configurationManager = (ConfigurationManager)page.getContentResource().getResourceResolver().adaptTo(ConfigurationManager.class);
        HierarchyNodeInheritanceValueMap pageProperties = new HierarchyNodeInheritanceValueMap(page.getContentResource());
        String[] services = (String[])pageProperties.getInherited("cq:cloudserviceconfigs", (Object)new String[0]);
        return configurationManager.getConfiguration(CLOUD_SERVICE_NAME, services);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.httpProxyHost = PropertiesUtil.toString((Object)properties.get(PROP_HTTP_PROXY_HOST), null);
        this.httpProxyPort = PropertiesUtil.toInteger((Object)properties.get(PROP_HTTP_PROXY_PORT), (int)0);
        this.useSsl = PropertiesUtil.toBoolean((Object)properties.get(PROP_USE_SSL), (boolean)true);
        this.factory = new TwitterFactory(this.buildConfiguration());
    }
}

