/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.images.impl;

import com.day.image.Layer;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageInputStream;

public class ProgressiveJpeg {
    private ProgressiveJpeg() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Layer layer, double quality, OutputStream out) throws IOException {
        ImageWriter writer = null;
        ImageInputStream imageOut = null;
        try {
            JPEGImageWriteParam iwp = new JPEGImageWriteParam(null);
            iwp.setCompressionMode(2);
            iwp.setProgressiveMode(1);
            iwp.setCompressionQuality((float)quality);
            writer = ImageIO.getImageWritersBySuffix("jpeg").next();
            imageOut = ImageIO.createImageOutputStream(out);
            writer.setOutput(imageOut);
            BufferedImage image = ProgressiveJpeg.getRgbImage(layer);
            writer.write(null, new IIOImage(image, null, null), iwp);
        }
        finally {
            if (writer != null) {
                writer.dispose();
            }
            if (imageOut != null) {
                try {
                    imageOut.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static BufferedImage getRgbImage(Layer layer) {
        BufferedImage rgbImage;
        BufferedImage image = layer.getImage();
        if (image.getType() != 1) {
            rgbImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            new ColorConvertOp(null).filter(image, rgbImage);
        } else {
            rgbImage = image;
        }
        return rgbImage;
    }
}

