/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.marketo.client;

import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketoApiException
extends IOException {
    private static final Logger log = LoggerFactory.getLogger(MarketoApiException.class);
    private final String requestLine;
    private final int statusCode;
    private final String reasonString;
    private final String responseBody;

    private static final String getResponseBody(HttpResponse response) {
        if (response != null) {
            try {
                return StringEscapeUtils.escapeHtml((String)StringUtils.abbreviate((String)EntityUtils.toString((HttpEntity)response.getEntity()), (int)100));
            }
            catch (IOException | ParseException e) {
                log.warn("Failed to read response from: {}", (Object)response, (Object)e);
            }
        }
        return null;
    }

    public MarketoApiException(String message, HttpRequestBase request, HttpResponse response) {
        this(message, request, response, MarketoApiException.getResponseBody(response), null);
    }

    public MarketoApiException(String message, HttpRequestBase request, HttpResponse response, String responseBody, Exception cause) {
        super(message, cause);
        this.requestLine = Optional.ofNullable(request).map(r -> r.getRequestLine().toString()).orElse(null);
        if (response != null) {
            this.statusCode = response.getStatusLine().getStatusCode();
            this.reasonString = response.getStatusLine().getReasonPhrase();
            this.responseBody = responseBody;
        } else {
            this.statusCode = -1;
            this.reasonString = null;
            this.responseBody = responseBody;
        }
    }

    public MarketoApiException(String message, HttpRequestBase request, HttpResponse response, String responseBody) {
        this(message, request, response, responseBody, null);
    }

    @Override
    public String getMessage() {
        return String.format("%s\tREQUEST{%s}\tRESPONSE{Status Code: %d, Reason Phrase: %s, Response Body: %s}", super.getMessage(), this.getRequestLine(), this.getStatusCode(), this.getReasonString(), this.getResponseBody());
    }

    public String getRequestLine() {
        return this.requestLine;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonString() {
        return this.reasonString;
    }

    public String getResponseBody() {
        return this.responseBody;
    }
}

