/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.packagegarbagecollector;

import com.adobe.acs.commons.packagegarbagecollector.PackageGarbageCollectionConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.ScheduledJobInfo;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=PackageGarbageCollectionConfig.class, factory=true)
public class PackageGarbageCollectionScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(PackageGarbageCollectionScheduler.class);
    public static final String JOB_TOPIC = "com/adobe/acs/commons/PackageGarbageCollectionJob";
    public static final String GROUP_NAME = "groupName";
    public static final String MAX_AGE_IN_DAYS = "maxAgeInDays";
    @Reference
    JobManager jobManager;
    ScheduledJobInfo job;

    @Activate
    protected void activate(PackageGarbageCollectionConfig config) {
        this.job = this.scheduleJob(config);
        if (LOG.isInfoEnabled() && this.job != null) {
            LOG.info("Next scheduled run for job with group name {} at {}", (Object)config.groupName(), (Object)this.job.getNextScheduledExecution());
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this.job != null) {
            this.job.unschedule();
        }
    }

    private ScheduledJobInfo scheduleJob(PackageGarbageCollectionConfig config) {
        Map<String, String> filter = Collections.singletonMap("=groupName", config.groupName());
        Collection existingJob = this.jobManager.getScheduledJobs(JOB_TOPIC, 1L, new Map[]{filter});
        if (existingJob.isEmpty()) {
            return this.jobManager.createJob(JOB_TOPIC).properties(this.getProperties(config)).schedule().cron(config.scheduler()).add();
        }
        LOG.info("Job for {} at {} already scheduled - just returning the existing one", (Object)config.groupName(), (Object)config.scheduler());
        return existingJob.stream().findFirst().orElse(null);
    }

    private Map<String, Object> getProperties(PackageGarbageCollectionConfig config) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(GROUP_NAME, config.groupName());
        properties.put(MAX_AGE_IN_DAYS, config.maxAgeInDays());
        return properties;
    }
}

