/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.rewriter.impl;

import acscommons.com.google.common.cache.Cache;
import acscommons.com.google.common.cache.CacheBuilder;
import com.adobe.acs.commons.rewriter.ContentHandlerBasedTransformer;
import com.adobe.acs.commons.rewriter.impl.SaxElementUtils;
import com.adobe.acs.commons.rewriter.impl.VersionedClientLibraryMd5CacheKey;
import com.adobe.acs.commons.util.RequireAem;
import com.adobe.acs.commons.util.impl.AbstractGuavaCacheMBean;
import com.adobe.acs.commons.util.impl.CacheMBean;
import com.adobe.acs.commons.util.impl.exception.CacheMBeanException;
import com.adobe.granite.ui.clientlibs.ClientLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.clientlibs.LibraryType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Transformer;
import org.apache.sling.rewriter.TransformerFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@Component(metatype=true, label="ACS AEM Commons - Versioned Clientlibs Transformer Factory", description="Sling Rewriter Transformer Factory to add auto-generated checksums to client library references")
@Properties(value={@Property(name="pipeline.type", value={"versioned-clientlibs"}, propertyPrivate=true), @Property(name="event.topics", value={"com/adobe/granite/ui/librarymanager/INVALIDATED"}, propertyPrivate=true), @Property(name="jmx.objectname", value={"com.adobe.acs.commons.rewriter:type=VersionedClientlibsTransformerMd5Cache"}, propertyPrivate=true)})
@Service(value={DynamicMBean.class, TransformerFactory.class, EventHandler.class})
public final class VersionedClientlibsTransformerFactory
extends AbstractGuavaCacheMBean<VersionedClientLibraryMd5CacheKey, String>
implements TransformerFactory,
EventHandler,
CacheMBean {
    private static final Logger log = LoggerFactory.getLogger(VersionedClientlibsTransformerFactory.class);
    private static final int DEFAULT_MD5_CACHE_SIZE = 300;
    private static final boolean DEFAULT_DISABLE_VERSIONING = false;
    private static final boolean DEFAULT_ENFORCE_MD5 = false;
    @Property(label="MD5 Cache Size", description="Maximum size of the md5 cache.", intValue={300})
    private static final String PROP_MD5_CACHE_SIZE = "md5cache.size";
    @Property(label="Disable Versioning", description="Should versioning of clientlibs be disabled", boolValue={false})
    private static final String PROP_DISABLE_VERSIONING = "disable.versioning";
    @Property(label="Enforce MD5", description="Enables a filter which returns a 404 error if the MD5 in the request does not match the expected value", boolValue={false})
    private static final String PROP_ENFORCE_MD5 = "enforce.md5";
    private static final String ATTR_JS_PATH = "src";
    private static final String ATTR_CSS_PATH = "href";
    private static final String MIN_SELECTOR = "min";
    private static final String MIN_SELECTOR_SEGMENT = ".min";
    private static final String MD5_PREFIX = "ACSHASH";
    private static final Pattern FILTER_PATTERN = Pattern.compile("(.*?)\\.(?:min.)?([a-zA-Z0-9]+)\\.(js|css)");
    private static final Pattern FILTER_PATTERN_ENFORCE_MD5 = Pattern.compile("(.*?)\\.(?:min.)?ACSHASH([a-zA-Z0-9]+)\\.(js|css)");
    private static final String PROXY_PREFIX = "/etc.clientlibs/";
    private static final String PROXIED_STATIC_RESOURCE_PATH = "/resources/";
    private Cache<VersionedClientLibraryMd5CacheKey, String> md5Cache;
    private volatile Map<String, ClientLibrary> clientLibrariesCache;
    private boolean disableVersioning;
    private boolean enforceMd5;
    @Reference
    private HtmlLibraryManager htmlLibraryManager;
    @Reference(target="(distribution=classic)")
    RequireAem requireAem;
    private ServiceRegistration<Filter> filterReg;

    public VersionedClientlibsTransformerFactory() throws NotCompliantMBeanException {
        super(CacheMBean.class);
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        BundleContext bundleContext = componentContext.getBundleContext();
        Dictionary props = componentContext.getProperties();
        int size = PropertiesUtil.toInteger(props.get(PROP_MD5_CACHE_SIZE), (int)300);
        this.md5Cache = CacheBuilder.newBuilder().recordStats().maximumSize(size).build();
        this.disableVersioning = PropertiesUtil.toBoolean(props.get(PROP_DISABLE_VERSIONING), (boolean)false);
        this.enforceMd5 = PropertiesUtil.toBoolean(props.get(PROP_ENFORCE_MD5), (boolean)false);
        if (this.enforceMd5) {
            Hashtable<String, Object> filterProps = new Hashtable<String, Object>();
            ((Dictionary)filterProps).put("sling.filter.scope", "REQUEST");
            ((Dictionary)filterProps).put("service.ranking", 0);
            this.filterReg = bundleContext.registerService(Filter.class, (Object)new BadMd5VersionedClientLibsFilter(), filterProps);
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this.filterReg != null) {
            this.filterReg.unregister();
            this.filterReg = null;
        }
        this.md5Cache = null;
        this.clientLibrariesCache = null;
    }

    public Transformer createTransformer() {
        return new VersionableClientlibsTransformer();
    }

    private Attributes versionClientLibs(String elementName, Attributes attrs, SlingHttpServletRequest request) {
        if (SaxElementUtils.isCss(elementName, attrs)) {
            return this.rebuildAttributes(new AttributesImpl(attrs), attrs.getIndex("", ATTR_CSS_PATH), attrs.getValue("", ATTR_CSS_PATH), LibraryType.CSS, request);
        }
        if (SaxElementUtils.isJavaScript(elementName, attrs)) {
            return this.rebuildAttributes(new AttributesImpl(attrs), attrs.getIndex("", ATTR_JS_PATH), attrs.getValue("", ATTR_JS_PATH), LibraryType.JS, request);
        }
        return attrs;
    }

    private Attributes rebuildAttributes(AttributesImpl newAttributes, int index, String path, LibraryType libraryType, SlingHttpServletRequest request) {
        String versionedPath;
        String contextPath = request.getContextPath();
        String libraryPath = path;
        if (StringUtils.isNotBlank((String)contextPath)) {
            libraryPath = path.substring(contextPath.length());
        }
        if (StringUtils.isNotBlank((String)(versionedPath = this.getVersionedPath(libraryPath, libraryType, request)))) {
            if (StringUtils.isNotBlank((String)contextPath)) {
                versionedPath = contextPath + versionedPath;
            }
            log.debug("Rewriting to: {}", (Object)versionedPath);
            newAttributes.setValue(index, versionedPath);
        } else {
            log.debug("Versioned Path could not be created properly");
        }
        return newAttributes;
    }

    private String getVersionedPath(String originalPath, LibraryType libraryType, SlingHttpServletRequest request) {
        if (originalPath.startsWith(PROXY_PREFIX) && originalPath.contains(PROXIED_STATIC_RESOURCE_PATH)) {
            log.debug("Static resource accessed via the clientlib proxy: '{}'", (Object)originalPath);
            return null;
        }
        try {
            HtmlLibrary htmlLibrary;
            boolean appendMinSelector = false;
            String libraryPath = StringUtils.substringBeforeLast((String)originalPath, (String)".");
            if (libraryPath.endsWith(MIN_SELECTOR_SEGMENT)) {
                appendMinSelector = true;
                libraryPath = StringUtils.substringBeforeLast((String)libraryPath, (String)".");
            }
            if ((htmlLibrary = this.getLibrary(libraryType, libraryPath, request)) != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(libraryPath);
                builder.append(".");
                if (appendMinSelector) {
                    builder.append(MIN_SELECTOR).append(".");
                }
                if (this.enforceMd5) {
                    builder.append(MD5_PREFIX);
                }
                builder.append(this.getMd5(htmlLibrary));
                builder.append(libraryType.extension);
                return builder.toString();
            }
            log.debug("Could not find HtmlLibrary at path: {}", (Object)libraryPath);
            return null;
        }
        catch (Exception ex) {
            log.error("Attempting to get a versioned path for [ {} ] but could not because of: {}", (Object)originalPath, (Object)ex.getMessage());
            return originalPath;
        }
    }

    private HtmlLibrary getLibrary(LibraryType libraryType, String libraryPath, SlingHttpServletRequest request) {
        String resolvedLibraryPath = this.resolvePath(libraryType, libraryPath, request);
        return resolvedLibraryPath == null ? null : this.htmlLibraryManager.getLibrary(libraryType, resolvedLibraryPath);
    }

    private String resolvePath(LibraryType libraryType, String libraryPath, SlingHttpServletRequest request) {
        if (!libraryPath.startsWith(PROXY_PREFIX)) {
            Resource libraryResource = request.getResourceResolver().resolve((HttpServletRequest)request, libraryPath);
            if (libraryResource != null && !(libraryResource instanceof NonExistingResource)) {
                return libraryResource.getPath();
            }
            return libraryPath;
        }
        return this.resolveProxiedClientLibrary(libraryType, libraryPath, request.getResourceResolver(), true);
    }

    private String resolveProxiedClientLibrary(LibraryType libraryType, String proxiedPath, ResourceResolver resourceResolver, boolean refreshCacheIfNotFound) {
        String relativePath = proxiedPath.substring(PROXY_PREFIX.length());
        for (String prefix : resourceResolver.getSearchPath()) {
            String absolutePath = prefix + relativePath;
            if (!this.hasProxyClientLibrary(libraryType, absolutePath)) continue;
            return absolutePath;
        }
        if (refreshCacheIfNotFound) {
            log.info("Refreshing client libraries cache, because {} could not be found", (Object)proxiedPath);
            this.clientLibrariesCache = null;
            return this.resolveProxiedClientLibrary(libraryType, proxiedPath, resourceResolver, false);
        }
        return null;
    }

    private boolean hasProxyClientLibrary(LibraryType type, String path) {
        ClientLibrary clientLibrary = this.getClientLibrary(path);
        return clientLibrary != null && clientLibrary.allowProxy() && clientLibrary.getTypes().contains(type);
    }

    private ClientLibrary getClientLibrary(String path) {
        if (this.clientLibrariesCache == null) {
            this.clientLibrariesCache = Collections.unmodifiableMap(this.htmlLibraryManager.getLibraries());
        }
        return this.clientLibrariesCache.get(path);
    }

    @Nonnull
    private String getMd5(final @Nonnull HtmlLibrary htmlLibrary) throws IOException, ExecutionException {
        return this.md5Cache.get(new VersionedClientLibraryMd5CacheKey(htmlLibrary), new Callable<String>(){

            @Override
            public String call() throws Exception {
                return VersionedClientlibsTransformerFactory.this.calculateMd5(htmlLibrary, VersionedClientlibsTransformerFactory.this.htmlLibraryManager.isMinifyEnabled());
            }
        });
    }

    @Nonnull
    private String calculateMd5(@Nonnull HtmlLibrary htmlLibrary, boolean isMinified) throws IOException {
        try (InputStream input = htmlLibrary.getInputStream(isMinified);){
            String string = DigestUtils.md5Hex((InputStream)input);
            return string;
        }
    }

    public void handleEvent(Event event) {
        String path = (String)event.getProperty("path");
        this.md5Cache.invalidate(new VersionedClientLibraryMd5CacheKey(path, LibraryType.JS));
        this.md5Cache.invalidate(new VersionedClientLibraryMd5CacheKey(path, LibraryType.CSS));
        this.clientLibrariesCache = null;
    }

    @Override
    protected Cache<VersionedClientLibraryMd5CacheKey, String> getCache() {
        return this.md5Cache;
    }

    @Override
    protected long getBytesLength(String cacheObj) {
        return cacheObj.getBytes(StandardCharsets.UTF_8).length;
    }

    @Override
    protected void addCacheData(Map<String, Object> data, String cacheObj) {
        data.put("Value", cacheObj);
    }

    @Override
    protected String toString(String cacheObj) throws CacheMBeanException {
        return cacheObj;
    }

    @Override
    protected CompositeType getCacheEntryType() throws OpenDataException {
        return new CompositeType("Cache Entry", "Cache Entry", new String[]{"Cache Key", "Value"}, new String[]{"Cache Key", "Value"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
    }

    @Nonnull
    UriInfo getUriInfo(@Nullable String uri, @Nonnull SlingHttpServletRequest request) {
        Matcher matcher;
        if (uri != null && (matcher = this.enforceMd5 ? FILTER_PATTERN_ENFORCE_MD5.matcher(uri) : FILTER_PATTERN.matcher(uri)).matches()) {
            String libraryPath = matcher.group(1);
            String md5 = matcher.group(2);
            String extension = matcher.group(3);
            LibraryType libraryType = LibraryType.CSS.extension.substring(1).equals(extension) ? LibraryType.CSS : LibraryType.JS;
            HtmlLibrary htmlLibrary = this.getLibrary(libraryType, libraryPath, request);
            return new UriInfo(libraryPath + "." + extension, md5, libraryType, htmlLibrary);
        }
        return new UriInfo("", "", null, null);
    }

    protected void bindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        this.htmlLibraryManager = htmlLibraryManager;
    }

    protected void unbindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        if (this.htmlLibraryManager == htmlLibraryManager) {
            this.htmlLibraryManager = null;
        }
    }

    protected void bindRequireAem(RequireAem requireAem) {
        this.requireAem = requireAem;
    }

    protected void unbindRequireAem(RequireAem requireAem) {
        if (this.requireAem == requireAem) {
            this.requireAem = null;
        }
    }

    class BadMd5VersionedClientLibsFilter
    implements Filter {
        BadMd5VersionedClientLibsFilter() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
            if (request instanceof SlingHttpServletRequest && response instanceof SlingHttpServletResponse) {
                SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
                SlingHttpServletResponse slingResponse = (SlingHttpServletResponse)response;
                String uri = slingRequest.getRequestURI();
                UriInfo uriInfo = VersionedClientlibsTransformerFactory.this.getUriInfo(uri, slingRequest);
                if (uriInfo.cacheKey != null) {
                    if ("".equals(uriInfo.md5)) {
                        log.debug("MD5 is blank for '{}' in Versioned ClientLibs cache, allowing {} to pass", (Object)uriInfo.cleanedUri, (Object)uri);
                        filterChain.doFilter(request, response);
                        return;
                    }
                    String md5FromCache = null;
                    try {
                        md5FromCache = VersionedClientlibsTransformerFactory.this.getCacheEntry(uriInfo.cacheKey);
                    }
                    catch (Exception e) {
                        log.debug("Failed to get cache entry for '{}'", (Object)uriInfo.cacheKey);
                    }
                    if ("Invalid cache key parameter.".equals(md5FromCache)) {
                        md5FromCache = VersionedClientlibsTransformerFactory.this.calculateMd5(uriInfo.htmlLibrary, VersionedClientlibsTransformerFactory.this.htmlLibraryManager.isMinifyEnabled());
                    }
                    if (md5FromCache == null) {
                        log.warn("Failed to fetch data from Versioned ClientLibs cache, allowing {} to pass", (Object)uri);
                        filterChain.doFilter(request, response);
                    } else if (md5FromCache.equals(uriInfo.md5)) {
                        log.debug("MD5 equals for '{}' in Versioned ClientLibs cache, allowing {} to pass", (Object)uriInfo.cleanedUri, (Object)uri);
                        filterChain.doFilter(request, response);
                    } else {
                        log.info("MD5 differs for '{}' in Versioned ClientLibs cache. Expected {}. Sending 404 for '{}'", new Object[]{uriInfo.cleanedUri, md5FromCache, uri});
                        slingResponse.sendError(404);
                    }
                } else {
                    filterChain.doFilter(request, response);
                }
            } else {
                filterChain.doFilter(request, response);
            }
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void destroy() {
        }
    }

    private class VersionableClientlibsTransformer
    extends ContentHandlerBasedTransformer {
        private SlingHttpServletRequest request;
        private boolean enabled;

        private VersionableClientlibsTransformer() {
        }

        @Override
        public void init(ProcessingContext context, ProcessingComponentConfiguration config) throws IOException {
            super.init(context, config);
            this.request = context.getRequest();
            this.enabled = this.request.getAttribute("pathRewritingOptions") == null;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
            Attributes nextAttributes = VersionedClientlibsTransformerFactory.this.disableVersioning || !this.enabled ? attrs : VersionedClientlibsTransformerFactory.this.versionClientLibs(localName, attrs, this.request);
            this.getContentHandler().startElement(namespaceURI, localName, qName, nextAttributes);
        }
    }

    static class UriInfo {
        private final String cleanedUri;
        private final String md5;
        private final HtmlLibrary htmlLibrary;
        private final String cacheKey;

        UriInfo(String cleanedUri, String md5, LibraryType libraryType, HtmlLibrary htmlLibrary) {
            this.cleanedUri = cleanedUri;
            this.md5 = md5;
            this.htmlLibrary = htmlLibrary;
            this.cacheKey = libraryType != null && htmlLibrary != null ? htmlLibrary.getLibraryPath() + libraryType.extension : null;
        }
    }
}

