/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.users.impl;

import com.adobe.acs.commons.search.CloseableQuery;
import com.adobe.acs.commons.search.CloseableQueryBuilder;
import com.adobe.acs.commons.users.impl.AbstractAuthorizable;
import com.adobe.acs.commons.users.impl.Ace;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.result.Hit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={EnsureAce.class})
public class EnsureAce {
    private static final Logger log = LoggerFactory.getLogger(EnsureAce.class);
    private static final String PROP_REP_GLOB = "rep:glob";
    private static final String PROP_REP_NT_NAMES = "rep:ntNames";
    private static final String PROP_REP_ITEM_NAMES = "rep:itemNames";
    private static final String PROP_REP_PREFIXES = "rep:prefixes";
    private static final String PROP_NT_REP_ACE = "rep:ACE";
    private static final String PROP_REP_PRINCIPAL_NAME = "rep:principalName";
    @Reference
    private CloseableQueryBuilder queryBuilder;

    public int ensureAces(ResourceResolver resourceResolver, Authorizable jcrAuthorizable, AbstractAuthorizable authorizable) throws RepositoryException {
        int failures = 0;
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        JackrabbitAccessControlManager accessControlManager = (JackrabbitAccessControlManager)session.getAccessControlManager();
        List<JackrabbitAccessControlList> acls = this.findAcls(resourceResolver, authorizable.getPrincipalName(), accessControlManager);
        for (JackrabbitAccessControlList acl : acls) {
            JackrabbitAccessControlEntry[] aces = (JackrabbitAccessControlEntry[])acl.getAccessControlEntries();
            boolean serviceUserCoversThisPath = authorizable.hasAceAt(acl.getPath());
            for (JackrabbitAccessControlEntry ace : aces) {
                if (!StringUtils.equals((String)authorizable.getPrincipalName(), (String)ace.getPrincipal().getName()) || StringUtils.startsWith((String)acl.getPath(), (String)jcrAuthorizable.getPath())) continue;
                if (!serviceUserCoversThisPath) {
                    log.debug("Service user does NOT cover the path yet has an ACE; ensure removal of the ace! {}", (Object)ace);
                    acl.removeAccessControlEntry((AccessControlEntry)ace);
                    continue;
                }
                Ace serviceUserAce = authorizable.getAce(ace, acl.getPath());
                if (serviceUserAce == null) {
                    acl.removeAccessControlEntry((AccessControlEntry)ace);
                    log.debug("Removed System ACE as it doesn't exist in Service User [ {} ] configuration", (Object)authorizable.getPrincipalName());
                    continue;
                }
                serviceUserAce.setExists(true);
                log.debug("No-op on System ACE as it already matches Service User [ {} ] configuration", (Object)authorizable.getPrincipalName());
            }
            accessControlManager.setPolicy(acl.getPath(), (AccessControlPolicy)acl);
        }
        for (Ace ace : authorizable.getMissingAces()) {
            if (resourceResolver.getResource(ace.getContentPath()) == null) {
                log.warn("Unable to apply Service User [ {} ] privileges due to missing path at [ {} ]. Please create the path and re-ensure this service user.", (Object)authorizable.getPrincipalName(), (Object)ace.getContentPath());
                ++failures;
                continue;
            }
            JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList((Session)session, (String)ace.getContentPath());
            HashMap<String, Value> restrictions = new HashMap<String, Value>();
            HashMap<String, Value[]> multiRestrictions = new HashMap<String, Value[]>();
            ValueFactory valueFactory = session.getValueFactory();
            if (ace.hasRepGlob()) {
                restrictions.put(PROP_REP_GLOB, valueFactory.createValue(ace.getRepGlob(), 1));
            }
            if (ace.hasRepNtNames()) {
                multiRestrictions.put(PROP_REP_NT_NAMES, this.getMultiValues(valueFactory, ace.getRepNtNames(), 7));
            }
            if (ace.hasRepItemNames()) {
                multiRestrictions.put(PROP_REP_ITEM_NAMES, this.getMultiValues(valueFactory, ace.getRepItemNames(), 7));
            }
            if (ace.hasRepPrefixes()) {
                multiRestrictions.put(PROP_REP_PREFIXES, this.getMultiValues(valueFactory, ace.getRepPrefixes(), 1));
            }
            acl.addEntry(jcrAuthorizable.getPrincipal(), ace.getPrivileges((AccessControlManager)accessControlManager).toArray(new Privilege[0]), ace.isAllow(), restrictions, multiRestrictions);
            accessControlManager.setPolicy(ace.getContentPath(), (AccessControlPolicy)acl);
            log.debug("Added Service User ACE for [ {} ] to [ {} ]", (Object)authorizable.getPrincipalName(), (Object)ace.getContentPath());
        }
        return failures;
    }

    public void removeAces(ResourceResolver resourceResolver, Authorizable jcrAuthorizable, AbstractAuthorizable authorizable) throws RepositoryException {
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        JackrabbitAccessControlManager accessControlManager = (JackrabbitAccessControlManager)session.getAccessControlManager();
        List<JackrabbitAccessControlList> acls = this.findAcls(resourceResolver, authorizable.getPrincipalName(), accessControlManager);
        for (JackrabbitAccessControlList acl : acls) {
            JackrabbitAccessControlEntry[] aces;
            for (JackrabbitAccessControlEntry ace : aces = (JackrabbitAccessControlEntry[])acl.getAccessControlEntries()) {
                if (!StringUtils.equals((String)authorizable.getPrincipalName(), (String)ace.getPrincipal().getName()) || jcrAuthorizable != null && StringUtils.startsWith((String)acl.getPath(), (String)jcrAuthorizable.getPath())) continue;
                acl.removeAccessControlEntry((AccessControlEntry)ace);
            }
            accessControlManager.setPolicy(acl.getPath(), (AccessControlPolicy)acl);
            log.debug("Removed ACE from ACL at [ {} ] for [ {} ]", (Object)acl.getPath(), (Object)authorizable.getPrincipalName());
        }
    }

    private List<JackrabbitAccessControlList> findAcls(ResourceResolver resourceResolver, String principalName, JackrabbitAccessControlManager accessControlManager) {
        HashSet<String> paths = new HashSet<String>();
        ArrayList<JackrabbitAccessControlList> acls = new ArrayList<JackrabbitAccessControlList>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", PROP_NT_REP_ACE);
        params.put("property", PROP_REP_PRINCIPAL_NAME);
        params.put("property.value", principalName);
        params.put("p.limit", "-1");
        try (CloseableQuery query = this.queryBuilder.createQuery(PredicateGroup.create(params), resourceResolver);){
            block11: for (Hit hit : query.getResult().getHits()) {
                try {
                    Resource aceResource = resourceResolver.getResource(hit.getPath());
                    Resource contentResource = aceResource.getParent().getParent();
                    if (paths.contains(contentResource.getPath())) continue;
                    paths.add(contentResource.getPath());
                    for (AccessControlPolicy policy : accessControlManager.getPolicies(contentResource.getPath())) {
                        if (!(policy instanceof JackrabbitAccessControlList)) continue;
                        acls.add((JackrabbitAccessControlList)policy);
                        continue block11;
                    }
                }
                catch (RepositoryException e) {
                    log.error("Failed to get resource for query result.", (Throwable)e);
                }
            }
        }
        return acls;
    }

    private Value[] getMultiValues(ValueFactory valueFactory, List<String> valueStrs, int propertyType) throws ValueFormatException {
        ArrayList<Value> result = new ArrayList<Value>();
        for (String valueStr : valueStrs) {
            result.add(valueFactory.createValue(valueStr, propertyType));
        }
        return result.toArray(new Value[result.size()]);
    }

    protected void bindQueryBuilder(CloseableQueryBuilder closeableQueryBuilder) {
        this.queryBuilder = closeableQueryBuilder;
    }

    protected void unbindQueryBuilder(CloseableQueryBuilder closeableQueryBuilder) {
        if (this.queryBuilder == closeableQueryBuilder) {
            this.queryBuilder = null;
        }
    }
}

