/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.vanity.impl;

import com.adobe.acs.commons.wcm.vanity.VanityURLService;
import com.adobe.acs.commons.wcm.vanity.impl.ExtensionlessRequestWrapper;
import com.adobe.acs.commons.wcm.vanity.impl.VanityUrlAdjuster;
import com.day.cq.commons.PathInfo;
import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={VanityURLService.class})
public class VanityURLServiceImpl
implements VanityURLService {
    private static final Logger log = LoggerFactory.getLogger(VanityURLServiceImpl.class);
    private static final String VANITY_DISPATCH_CHECK_ATTR = "acs-aem-commons__vanity-check-loop-detection";
    private static final String DEFAULT_PATH_SCOPE = "/content";
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private VanityUrlAdjuster vanityUrlAdjuster;

    @Override
    public boolean dispatch(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException, RepositoryException {
        if (request.getAttribute(VANITY_DISPATCH_CHECK_ATTR) != null) {
            log.trace("Processing a previously vanity dispatched request. Skipping...");
            return false;
        }
        request.setAttribute(VANITY_DISPATCH_CHECK_ATTR, (Object)true);
        String requestURI = request.getRequestURI();
        PathInfo pathInfo = new PathInfo(request.getResourceResolver(), requestURI);
        String candidateVanity = pathInfo.getResourcePath();
        if (request.getResourceResolver().resolve(requestURI) == null) {
            candidateVanity = request.getResourceResolver().map((HttpServletRequest)request, candidateVanity);
        }
        log.trace("Generated Candidate Vanity URL from the mapping of [ {} -> {} ]", (Object)requestURI, (Object)candidateVanity);
        String pathScope = StringUtils.removeEnd((String)requestURI, (String)candidateVanity);
        log.debug("Candidate vanity URL to check and dispatch: [ {} ]", (Object)candidateVanity);
        if (this.vanityUrlAdjuster != null) {
            String originalCandidateVanity = candidateVanity;
            candidateVanity = this.vanityUrlAdjuster.adjust(request, candidateVanity);
            log.debug("Custom adjustment of candidate vanity [ {} -> {} ]", (Object)originalCandidateVanity, (Object)candidateVanity);
        }
        if (!StringUtils.equals((CharSequence)candidateVanity, (CharSequence)requestURI) && this.isVanityPath(pathScope, candidateVanity, request)) {
            log.debug("Forwarding request to vanity resource [ {} ]", (Object)candidateVanity);
            RequestDispatcher requestDispatcher = request.getRequestDispatcher(candidateVanity);
            requestDispatcher.forward((ServletRequest)new ExtensionlessRequestWrapper(request), (ServletResponse)response);
            return true;
        }
        return false;
    }

    protected boolean isVanityPath(String pathScope, String vanityPath, SlingHttpServletRequest request) throws RepositoryException {
        Resource vanityResource = request.getResourceResolver().resolve(vanityPath);
        if (vanityResource != null) {
            String targetPath = null;
            if (vanityResource.isResourceType("sling:redirect")) {
                targetPath = (String)vanityResource.getValueMap().get("sling:target", String.class);
            } else if (!StringUtils.equals((CharSequence)vanityPath, (CharSequence)vanityResource.getPath())) {
                targetPath = vanityResource.getPath();
            }
            if (targetPath != null && StringUtils.startsWith((CharSequence)targetPath, (CharSequence)StringUtils.defaultIfEmpty((CharSequence)pathScope, (CharSequence)DEFAULT_PATH_SCOPE))) {
                log.debug("Found vanity resource at [ {} ] for sling:vanityPath [ {} ]", (Object)targetPath, (Object)vanityPath);
                return true;
            }
        }
        return false;
    }
}

