/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wrap.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import javax.annotation.Nonnull;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.retention.RetentionManager;
import javax.jcr.security.AccessControlManager;
import javax.jcr.version.VersionException;
import org.osgi.annotation.versioning.ProviderType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@ProviderType
public interface BaseSessionIWrap<S extends Session>
extends Session {
    public S unwrapSession();

    @Nonnull
    default public <T extends Item> T wrapItem(@Nonnull T item) {
        return item;
    }

    @Nonnull
    default public Session wrapSession(@Nonnull Session session) {
        return session;
    }

    @Nonnull
    default public Workspace wrapWorkspace(@Nonnull Workspace workspace) {
        return workspace;
    }

    default public Repository getRepository() {
        return this.unwrapSession().getRepository();
    }

    default public String getUserID() {
        return this.unwrapSession().getUserID();
    }

    default public String[] getAttributeNames() {
        return this.unwrapSession().getAttributeNames();
    }

    default public Object getAttribute(String name) {
        return this.unwrapSession().getAttribute(name);
    }

    default public Workspace getWorkspace() {
        return this.wrapWorkspace(this.unwrapSession().getWorkspace());
    }

    default public Node getRootNode() throws RepositoryException {
        return this.unwrapSession().getRootNode();
    }

    default public Session impersonate(Credentials credentials) throws LoginException, RepositoryException {
        return this.wrapSession(this.unwrapSession().impersonate(credentials));
    }

    default public Node getNodeByUUID(String uuid) throws ItemNotFoundException, RepositoryException {
        return this.wrapItem(this.unwrapSession().getNodeByUUID(uuid));
    }

    default public Node getNodeByIdentifier(String id) throws ItemNotFoundException, RepositoryException {
        return this.wrapItem(this.unwrapSession().getNodeByIdentifier(id));
    }

    default public Item getItem(String absPath) throws PathNotFoundException, RepositoryException {
        return this.wrapItem(this.unwrapSession().getItem(absPath));
    }

    default public Node getNode(String absPath) throws PathNotFoundException, RepositoryException {
        return this.wrapItem(this.unwrapSession().getNode(absPath));
    }

    default public Property getProperty(String absPath) throws PathNotFoundException, RepositoryException {
        return this.wrapItem(this.unwrapSession().getProperty(absPath));
    }

    default public boolean itemExists(String absPath) throws RepositoryException {
        return this.unwrapSession().itemExists(absPath);
    }

    default public boolean nodeExists(String absPath) throws RepositoryException {
        return this.unwrapSession().nodeExists(absPath);
    }

    default public boolean propertyExists(String absPath) throws RepositoryException {
        return this.unwrapSession().propertyExists(absPath);
    }

    default public void move(String srcAbsPath, String destAbsPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.unwrapSession().move(srcAbsPath, destAbsPath);
    }

    default public void removeItem(String absPath) throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        this.unwrapSession().removeItem(absPath);
    }

    default public void save() throws AccessDeniedException, ItemExistsException, ReferentialIntegrityException, ConstraintViolationException, InvalidItemStateException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        this.unwrapSession().save();
    }

    default public void refresh(boolean keepChanges) throws RepositoryException {
        this.unwrapSession().refresh(keepChanges);
    }

    default public boolean hasPendingChanges() throws RepositoryException {
        return this.unwrapSession().hasPendingChanges();
    }

    default public ValueFactory getValueFactory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.unwrapSession().getValueFactory();
    }

    default public boolean hasPermission(String absPath, String actions) throws RepositoryException {
        return this.unwrapSession().hasPermission(absPath, actions);
    }

    default public void checkPermission(String absPath, String actions) throws AccessControlException, RepositoryException {
        this.unwrapSession().checkPermission(absPath, actions);
    }

    default public boolean hasCapability(String methodName, Object target, Object[] arguments) throws RepositoryException {
        return this.unwrapSession().hasCapability(methodName, target, arguments);
    }

    default public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        return this.unwrapSession().getImportContentHandler(parentAbsPath, uuidBehavior);
    }

    default public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, VersionException, InvalidSerializedDataException, LockException, RepositoryException {
        this.unwrapSession().importXML(parentAbsPath, in, uuidBehavior);
    }

    default public void exportSystemView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        this.unwrapSession().exportSystemView(absPath, contentHandler, skipBinary, noRecurse);
    }

    default public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        this.unwrapSession().exportSystemView(absPath, out, skipBinary, noRecurse);
    }

    default public void exportDocumentView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        this.unwrapSession().exportDocumentView(absPath, contentHandler, skipBinary, noRecurse);
    }

    default public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        this.unwrapSession().exportDocumentView(absPath, out, skipBinary, noRecurse);
    }

    default public void setNamespacePrefix(String prefix, String uri) throws NamespaceException, RepositoryException {
        this.unwrapSession().setNamespacePrefix(prefix, uri);
    }

    default public String[] getNamespacePrefixes() throws RepositoryException {
        return this.unwrapSession().getNamespacePrefixes();
    }

    default public String getNamespaceURI(String prefix) throws NamespaceException, RepositoryException {
        return this.unwrapSession().getNamespaceURI(prefix);
    }

    default public String getNamespacePrefix(String uri) throws NamespaceException, RepositoryException {
        return this.unwrapSession().getNamespacePrefix(uri);
    }

    default public void logout() {
        this.unwrapSession().logout();
    }

    default public boolean isLive() {
        return this.unwrapSession().isLive();
    }

    default public void addLockToken(String lt) {
        this.unwrapSession().addLockToken(lt);
    }

    default public String[] getLockTokens() {
        return this.unwrapSession().getLockTokens();
    }

    default public void removeLockToken(String lt) {
        this.unwrapSession().removeLockToken(lt);
    }

    default public AccessControlManager getAccessControlManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.unwrapSession().getAccessControlManager();
    }

    default public RetentionManager getRetentionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.unwrapSession().getRetentionManager();
    }
}

