/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.exporters.impl.tags;

import acscommons.com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={TagsExportService.class})
public class TagsExportService {
    private static final Logger log = LoggerFactory.getLogger(TagsExportService.class);
    private static final String TAGS_QUERY = "SELECT * FROM [cq:Tag] AS s WHERE ISDESCENDANTNODE('%s')";
    private static final String DEFAULT_LANGUAGE = "en";
    private static final String[] TAGS_ROOTS = new String[]{"tags", "cq:Tags"};
    private static final String LOCALIZED_JCR_TITLE = "jcr:title.";
    private static final int ROOT_TAG_LEVEL = 3;
    private static final int ARRAY_INDEX_CORRECTION = 1;

    public String exportNonLocalizedTagsForPath(String path, ResourceResolver rr) {
        return this.exportTagsForPath(path, rr, DEFAULT_LANGUAGE, TagExportMode.NON_LOCALIZED);
    }

    public String exportLocalizedTagsForPath(String path, ResourceResolver rr) {
        return this.exportLocalizedTagsForPath(path, rr, DEFAULT_LANGUAGE);
    }

    public String exportLocalizedTagsForPath(String path, ResourceResolver rr, String lang) {
        return this.exportTagsForPath(path, rr, lang, TagExportMode.LOCALIZED);
    }

    private String exportTagsForPath(String path, ResourceResolver rr, String lang, TagExportMode mode) {
        StringBuilder result = new StringBuilder();
        if (TagsExportService.containsTagRoot(path)) {
            List<Resource> tags = TagsExportService.getAllTags(path, rr);
            int tagsDepth = TagsExportService.tagsDepth(tags);
            if (tagsDepth != 0) {
                String[] tagArray = new String[tagsDepth];
                tags.forEach(tag -> {
                    Arrays.fill(tagArray, "");
                    if (TagExportMode.LOCALIZED.equals((Object)mode)) {
                        result.append(TagsExportService.tagLocalizedAsCsv(tag, tagArray, lang));
                    } else {
                        result.append(TagsExportService.tagNonLocalizedAsCsv(tag, tagArray));
                    }
                });
            }
            log.info("Tags in number of {} has been exported for root path {}", (Object)tags.size(), (Object)path);
        } else {
            result.append(String.format("Path '%s' do not contains tag root. Probably You've made mistake during typing path. Export tags cannot be done.", path));
            log.error("Path {} does not contain tags root path. Export tags cannot be done.", (Object)path);
        }
        return result.toString();
    }

    private static boolean containsTagRoot(String path) {
        return Arrays.stream(path.split("/")).anyMatch(segment -> StringUtils.equalsAnyIgnoreCase((CharSequence)segment, (CharSequence[])TAGS_ROOTS));
    }

    private static List<Resource> getAllTags(String path, ResourceResolver rr) {
        return Lists.newArrayList(rr.findResources(String.format(TAGS_QUERY, path), "JCR-SQL2"));
    }

    private static int tagsDepth(List<Resource> tags) {
        return tags.stream().map(Resource::getPath).map(s -> s.split("/").length).reduce(Integer::max).map(v -> v - 3).orElse(0);
    }

    private static String tagLocalizedAsCsv(Resource resource, String[] tagElements, String lang) {
        if (!StringUtils.equalsAnyIgnoreCase((CharSequence)resource.getName(), (CharSequence[])TAGS_ROOTS)) {
            ValueMap map = resource.getValueMap();
            int arrayIndex = TagsExportService.calculateArrayIndex(resource);
            Set<String> keys = TagsExportService.getTitleKeys(map);
            String name = TagsExportService.extractName(resource);
            if (keys.isEmpty()) {
                String title = TagsExportService.extractTitle(resource, "jcr:title", name);
                tagElements[arrayIndex] = lang + "[" + title + "] {{" + name + "}}";
            } else {
                keys.forEach(key -> {
                    String title = TagsExportService.extractTitle(resource, key, name);
                    String localLang = StringUtils.substringAfter((String)key, (String)LOCALIZED_JCR_TITLE);
                    int n = arrayIndex;
                    tagElements[n] = tagElements[n] + localLang + "[" + title + "] ";
                });
                int n = arrayIndex;
                tagElements[n] = tagElements[n] + "{{" + resource.getName() + "}}";
            }
            return TagsExportService.tagLocalizedAsCsv(resource.getParent(), tagElements, lang);
        }
        return TagsExportService.createTagRow(tagElements);
    }

    private static String tagNonLocalizedAsCsv(Resource resource, String[] tagElements) {
        if (!StringUtils.equalsAnyIgnoreCase((CharSequence)resource.getName(), (CharSequence[])TAGS_ROOTS)) {
            String name = TagsExportService.extractName(resource);
            String title = TagsExportService.extractTitle(resource, "jcr:title", name);
            tagElements[TagsExportService.calculateArrayIndex((Resource)resource)] = title + " {{" + name + "}}";
            return TagsExportService.tagNonLocalizedAsCsv(resource.getParent(), tagElements);
        }
        return TagsExportService.createTagRow(tagElements);
    }

    private static Set<String> getTitleKeys(ValueMap map) {
        return map.keySet().stream().filter(key -> key.startsWith(LOCALIZED_JCR_TITLE)).collect(Collectors.toSet());
    }

    private static int calculateArrayIndex(Resource resource) {
        return resource.getPath().split("/").length - 3 - 1;
    }

    private static String extractName(Resource resource) {
        return StringUtils.substringAfterLast((String)resource.getPath(), (String)"/");
    }

    private static String extractTitle(Resource resource, String key, String defaultTitle) {
        return ((String)resource.getValueMap().get(key, (Object)defaultTitle)).replaceAll(",", " ");
    }

    private static String createTagRow(String[] tagElements) {
        return String.join((CharSequence)",", tagElements) + ",\n";
    }

    private static enum TagExportMode {
        NON_LOCALIZED,
        LOCALIZED;

    }
}

