/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.granite.ui.components.impl.include;

import com.adobe.acs.commons.granite.ui.components.impl.include.NamespaceDecoratedValueMapBuilder;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.FilteringResourceWrapper;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.iterators.TransformIterator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class NamespaceResourceWrapper
extends FilteringResourceWrapper {
    private final ExpressionResolver expressionResolver;
    private final SlingHttpServletRequest request;
    private final String[] namespacedProperties;
    private final ValueMap valueMap;

    public NamespaceResourceWrapper(@Nonnull Resource resource, @Nonnull ExpressionResolver expressionResolver, @Nonnull SlingHttpServletRequest request, String[] namespacedProperties) {
        super(resource, expressionResolver, request);
        this.expressionResolver = expressionResolver;
        this.request = request;
        this.namespacedProperties = namespacedProperties;
        this.valueMap = new NamespaceDecoratedValueMapBuilder(request, resource, namespacedProperties).build();
    }

    public Resource getChild(String relPath) {
        Resource child = super.getChild(relPath);
        if (child == null) {
            return null;
        }
        NamespaceResourceWrapper wrapped = new NamespaceResourceWrapper(child, this.expressionResolver, this.request, this.namespacedProperties);
        if (!this.isVisible((Resource)wrapped)) {
            return null;
        }
        return wrapped;
    }

    public Iterator<Resource> listChildren() {
        return new TransformIterator((Iterator)new FilterIterator(super.listChildren(), o -> this.isVisible((Resource)new NamespaceResourceWrapper((Resource)o, this.expressionResolver, this.request, this.namespacedProperties))), o -> new NamespaceResourceWrapper((Resource)o, this.expressionResolver, this.request, this.namespacedProperties));
    }

    private boolean isVisible(Resource o) {
        return (Boolean)o.getValueMap().get("hide", (Object)Boolean.FALSE) == false;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class) {
            return (AdapterType)this.getValueMap();
        }
        return (AdapterType)super.adaptTo(type);
    }

    public ValueMap getValueMap() {
        return this.valueMap;
    }
}

