/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.jcr.impl.writer;

import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.store.jcr.impl.exceptions.BucketNodeFactoryException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.JcrUtils;

public class BucketNodeFactory {
    public static final double HASHCODE_LENGTH = 10.0;
    private final CacheKey key;
    private final int cacheKeySplitDepth;
    private final Node cacheRoot;

    public BucketNodeFactory(Session session, String cacheRootPath, CacheKey key, Integer cacheKeySplitDepth) throws RepositoryException, BucketNodeFactoryException {
        this.key = key;
        this.cacheKeySplitDepth = cacheKeySplitDepth;
        if (!session.nodeExists(cacheRootPath)) {
            throw new BucketNodeFactoryException("Cache root path " + cacheRootPath + " not found!");
        }
        this.cacheRoot = session.getNode(cacheRootPath);
    }

    public Node getBucketNode() throws RepositoryException {
        String[] pathArray = this.getPathArray();
        Node targetNode = this.cacheRoot;
        for (String path : pathArray) {
            Node childNode = JcrUtils.getOrCreateByPath((Node)targetNode, (String)path, (boolean)false, (String)"oak:Unstructured", (String)"oak:Unstructured", (boolean)false);
            if (!childNode.hasProperty("isBucketNode")) {
                childNode.setProperty("isBucketNode", true);
            }
            targetNode = childNode;
        }
        return targetNode;
    }

    private String[] getPathArray() {
        String hashCodeString = StringUtils.leftPad((String)String.valueOf(this.key.hashCode()), (int)10, (String)"0");
        int increment = (int)Math.ceil(10.0 / (double)this.cacheKeySplitDepth);
        String[] pathArray = new String[this.cacheKeySplitDepth];
        int position = 0;
        for (int i = 0; i < this.cacheKeySplitDepth; ++i) {
            String nodeName;
            int endIndex = position + increment > hashCodeString.length() ? hashCodeString.length() : position + increment;
            pathArray[i] = nodeName = StringUtils.leftPad((String)hashCodeString.substring(position, endIndex), (int)5, (String)"0");
            position += increment;
        }
        return pathArray;
    }
}

