/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirectmaps.impl;

import com.adobe.acs.commons.redirectmaps.impl.RedirectEntriesUtils;
import com.adobe.acs.commons.util.RequireAem;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"POST"}, resourceTypes={"acs-commons/components/utilities/redirectmappage"}, selectors={"updateentry"}, extensions={"json"}, metatype=false)
public class UpdateEntryServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -1704915461516132101L;
    private static final Logger log = LoggerFactory.getLogger(UpdateEntryServlet.class);
    @Reference(target="(distribution=classic)")
    RequireAem requireAem;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        log.trace("doPost");
        String source = request.getParameter("edit-source");
        String target = request.getParameter("edit-target");
        int idx = Integer.parseInt(request.getParameter("edit-id"), 10);
        log.debug("Updating entry {} with {} {}", new Object[]{idx, source, target});
        List<String> lines = RedirectEntriesUtils.readEntries(request);
        lines.set(idx, source + " " + target);
        log.debug("Updated entry...");
        log.trace("Saving lines {}", lines);
        RedirectEntriesUtils.updateRedirectMap(request, lines);
        RedirectEntriesUtils.writeEntriesToResponse(request, response, "Updated entry " + idx + " to " + source + " " + target);
    }

    protected void bindRequireAem(RequireAem requireAem) {
        this.requireAem = requireAem;
    }

    protected void unbindRequireAem(RequireAem requireAem) {
        if (this.requireAem == requireAem) {
            this.requireAem = null;
        }
    }
}

