/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.models;

import com.adobe.acs.commons.redirects.models.SubstitutionElement;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
public class RedirectRule {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SOURCE_PROPERTY_NAME = "source";
    public static final String TARGET_PROPERTY_NAME = "target";
    public static final String STATUS_CODE_PROPERTY_NAME = "statusCode";
    public static final String UNTIL_DATE_PROPERTY_NAME = "untilDate";
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd MMMM yyyy");
    @Inject
    private String source;
    @Inject
    private String target;
    @Inject
    private int statusCode;
    private String untilDate;
    private Pattern ptrn;
    private SubstitutionElement[] substitutions;

    public RedirectRule(ValueMap resource) {
        this((String)resource.get(SOURCE_PROPERTY_NAME, (Object)""), (String)resource.get(TARGET_PROPERTY_NAME, (Object)""), (Integer)resource.get(STATUS_CODE_PROPERTY_NAME, (Object)0), (String)resource.get(UNTIL_DATE_PROPERTY_NAME, String.class));
    }

    public RedirectRule(String source, String target, int statusCode, String untilStr) {
        this.source = source.trim();
        this.target = target.trim();
        this.statusCode = statusCode;
        String regex = this.source;
        if (regex.endsWith("*")) {
            regex = regex.replaceAll("\\*$", "(.*)");
        }
        this.ptrn = RedirectRule.toRegex(regex);
        this.substitutions = SubstitutionElement.parse(this.target);
        if (StringUtils.isNotBlank((CharSequence)untilStr)) {
            this.untilDate = untilStr.trim();
        }
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Pattern getRegex() {
        return this.ptrn;
    }

    public String getUntilDate() {
        return this.untilDate;
    }

    public ZonedDateTime getUntilDateTime() {
        if (this.untilDate != null && !this.untilDate.isEmpty()) {
            try {
                LocalDate ld = DATE_FORMATTER.parse(this.untilDate).query(LocalDate::from);
                return ld == null ? null : ld.atStartOfDay().plusDays(1L).minusSeconds(1L).atZone(ZoneId.systemDefault());
            }
            catch (DateTimeParseException e) {
                log.error("Invalid UntilDateTime {}", (Object)this.untilDate, (Object)e);
            }
        }
        return null;
    }

    public String toString() {
        return String.format("RedirectRule{source='%s', target='%s', statusCode=%s, untilDate=%s}", this.source, this.target, this.statusCode, this.untilDate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedirectRule that = (RedirectRule)o;
        return this.source != null ? this.source.equals(that.source) : that.source == null;
    }

    public int hashCode() {
        return this.source != null ? this.source.hashCode() : 0;
    }

    public String evaluate(Matcher matcher) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.substitutions.length; ++i) {
            buf.append(this.substitutions[i].evaluate(matcher));
        }
        return buf.toString();
    }

    static Pattern toRegex(String src) {
        Pattern ptrn;
        try {
            ptrn = Pattern.compile(src);
            int groupCount = ptrn.matcher("").groupCount();
            if (groupCount == 0) {
                ptrn = null;
            }
        }
        catch (PatternSyntaxException e) {
            log.info("invalid regex: {}", (Object)src);
            ptrn = null;
        }
        return ptrn;
    }
}

