/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.twitter.impl;

import acscommons.com.google.common.annotations.VisibleForTesting;
import com.adobe.acs.commons.twitter.TwitterClient;
import com.adobe.acs.commons.twitter.impl.TwitterClientImpl;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.conf.ConfigurationBuilder;

class TwitterAdapterFactory
implements AdapterFactory {
    private static final String CLOUD_SERVICE_NAME = "twitterconnect";
    private static final Logger log = LoggerFactory.getLogger(TwitterAdapterFactory.class);
    private final TwitterFactory factory;
    private final String httpProxyHost;
    private final int httpProxyPort;
    private final boolean useSsl;

    TwitterAdapterFactory(String httpProxyHost, int httpProxyPort, boolean useSsl) {
        this.httpProxyHost = httpProxyHost;
        this.httpProxyPort = httpProxyPort;
        this.useSsl = useSsl;
        this.factory = new TwitterFactory(this.buildConfiguration());
    }

    @VisibleForTesting
    TwitterAdapterFactory() {
        this(null, 0, true);
    }

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        TwitterClient client = null;
        if (adaptable instanceof Page) {
            client = this.createTwitterClientFromPage((Page)adaptable);
        } else if (adaptable instanceof Configuration) {
            client = this.createTwitterClientFromConfiguration((Configuration)adaptable);
        }
        if (client != null) {
            if (type == TwitterClient.class) {
                return (AdapterType)client;
            }
            if (type == Twitter.class) {
                return (AdapterType)client.getTwitter();
            }
        }
        return null;
    }

    private twitter4j.conf.Configuration buildConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.setUseSSL(this.useSsl);
        builder.setJSONStoreEnabled(true);
        builder.setApplicationOnlyAuthEnabled(true);
        if (StringUtils.isNotBlank((String)this.httpProxyHost) && this.httpProxyPort > 0) {
            builder.setHttpProxyHost(this.httpProxyHost);
            builder.setHttpProxyPort(this.httpProxyPort);
        }
        return builder.build();
    }

    private TwitterClient createTwitterClientFromConfiguration(Configuration config) {
        Resource oauthConfig = (Resource)config.getContentResource().listChildren().next();
        ValueMap oauthProps = oauthConfig.getValueMap();
        String consumerKey = (String)oauthProps.get("oauth.client.id", String.class);
        String consumerSecret = (String)oauthProps.get("oauth.client.secret", String.class);
        if (consumerKey != null && consumerSecret != null) {
            Twitter twitter = this.getInstance();
            log.debug("Creating client for key {}.", (Object)consumerKey);
            twitter.setOAuthConsumer(consumerKey, consumerSecret);
            try {
                twitter.getOAuth2Token();
                return new TwitterClientImpl(twitter, config);
            }
            catch (TwitterException e) {
                log.error("Unable to create Twitter client.", (Throwable)e);
                return null;
            }
        }
        log.warn("Key or Secret missing for configuration {}", (Object)config.getPath());
        return null;
    }

    @VisibleForTesting
    Twitter getInstance() {
        return this.factory.getInstance();
    }

    private TwitterClient createTwitterClientFromPage(Page page) {
        Configuration config = this.findTwitterConfiguration(page);
        if (config != null) {
            return this.createTwitterClientFromConfiguration(config);
        }
        return null;
    }

    private Configuration findTwitterConfiguration(Page page) {
        ConfigurationManager configurationManager = (ConfigurationManager)page.getContentResource().getResourceResolver().adaptTo(ConfigurationManager.class);
        HierarchyNodeInheritanceValueMap pageProperties = new HierarchyNodeInheritanceValueMap(page.getContentResource());
        String[] services = (String[])pageProperties.getInherited("cq:cloudserviceconfigs", (Object)new String[0]);
        return configurationManager.getConfiguration(CLOUD_SERVICE_NAME, services);
    }
}

