/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.impl;

import com.adobe.acs.commons.util.ClusterLeader;
import org.apache.sling.discovery.DiscoveryService;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.TopologyView;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component
public class DiscoveryServiceHelper
implements TopologyEventListener {
    @Reference
    DiscoveryService discoveryService;
    private BundleContext bundleContext;
    ServiceRegistration<ClusterLeader> clusterLeaderServiceRegistration;

    public void handleTopologyEvent(TopologyEvent event) {
        TopologyView newView = event.getNewView();
        if (newView != null) {
            if (newView.getLocalInstance().isLeader()) {
                this.registerClusterLeader();
            } else {
                this.unregisterClusterLeader();
            }
        }
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        if (this.discoveryService.getTopology().getLocalInstance().isLeader()) {
            this.registerClusterLeader();
        }
    }

    @Deactivate
    public void deactivate() {
        this.unregisterClusterLeader();
    }

    private synchronized void registerClusterLeader() {
        if (this.clusterLeaderServiceRegistration == null) {
            this.clusterLeaderServiceRegistration = this.bundleContext.registerService(ClusterLeader.class, (Object)new ClusterLeader(){}, null);
        }
    }

    private synchronized void unregisterClusterLeader() {
        if (this.clusterLeaderServiceRegistration != null) {
            this.clusterLeaderServiceRegistration.unregister();
            this.clusterLeaderServiceRegistration = null;
        }
    }
}

