/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.data;

import com.adobe.acs.commons.data.Variant;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class CompositeVariant<T> {
    private final Class type;
    private final List<Variant> values = new ArrayList<Variant>();

    public CompositeVariant(T initial) {
        if (initial instanceof Class) {
            this.type = (Class)initial;
        } else {
            this.type = initial instanceof Variant ? ((Variant)initial).getBaseType() : initial.getClass();
            this.addValue(initial);
        }
    }

    public boolean isArray() {
        return this.type.isArray();
    }

    public Class<T> getSingularType() {
        if (this.isArray()) {
            return this.type.getComponentType();
        }
        return this.type;
    }

    public boolean isEmpty() {
        return this.values.isEmpty() || this.getValue() == null;
    }

    public final void addValue(Object val) {
        if (val instanceof Variant) {
            this.values.add((Variant)val);
        } else {
            this.values.add(new Variant(val));
        }
    }

    public T getValue() {
        return this.getValueAs(this.getSingularType());
    }

    public <U> U getValueAs(Class<U> otherType) {
        return this.values.isEmpty() ? null : (U)this.values.get(0).asType(otherType);
    }

    public List<T> getValues() {
        return this.getValuesAs(this.getSingularType());
    }

    public <U> List<U> getValuesAs(Class<U> otherType) {
        return this.values.stream().map(v -> this.getValueAsType((Variant)v, otherType)).collect(Collectors.toList());
    }

    private <U> U getValueAsType(Variant v, Class<U> type) {
        return v.asType(type);
    }

    public String toString() {
        if (this.isArray()) {
            return this.getValues().toString();
        }
        return this.getValueAs(String.class);
    }

    public Object toPropertyValue() {
        if (this.isArray()) {
            Object arr = Array.newInstance(this.getSingularType(), 0);
            return this.getValues().toArray((Object[])arr);
        }
        return this.getValue();
    }
}

