/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.mem.impl;

import acscommons.com.google.common.cache.Cache;
import acscommons.com.google.common.cache.CacheBuilder;
import acscommons.com.google.common.cache.RemovalListener;
import acscommons.com.google.common.cache.RemovalNotification;
import acscommons.com.google.common.cache.Weigher;
import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.engine.CacheContent;
import com.adobe.acs.commons.httpcache.exception.HttpCacheDataStreamException;
import com.adobe.acs.commons.httpcache.exception.HttpCacheKeyCreationException;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.store.HttpCacheStore;
import com.adobe.acs.commons.httpcache.store.TempSink;
import com.adobe.acs.commons.httpcache.store.mem.impl.MemCacheMBean;
import com.adobe.acs.commons.httpcache.store.mem.impl.MemCachePersistenceObject;
import com.adobe.acs.commons.httpcache.store.mem.impl.MemTempSinkImpl;
import com.adobe.acs.commons.util.impl.AbstractGuavaCacheMBean;
import com.adobe.acs.commons.util.impl.exception.CacheMBeanException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - HTTP Cache - In-Memory cache store", description="Cache data store implementation for in-memory storage.", metatype=true)
@Properties(value={@Property(name="httpcache.cachestore.type", value={"MEM"}, propertyPrivate=true), @Property(name="jmx.objectname", value={"com.adobe.acs.commons.httpcache:type=HTTP Cache - In-Memory Cache Store"}, propertyPrivate=true), @Property(name="webconsole.configurationFactory.nameHint", value={"TTL: {httpcache.cachestore.memcache.ttl}, Max size in MB: {httpcache.cachestore.memcache.maxsize}"}, propertyPrivate=true)})
@Service(value={HttpCacheStore.class})
public class MemHttpCacheStoreImpl
extends AbstractGuavaCacheMBean<CacheKey, MemCachePersistenceObject>
implements HttpCacheStore,
MemCacheMBean {
    private static final Logger log = LoggerFactory.getLogger(MemHttpCacheStoreImpl.class);
    private static final long MEGABYTE = 0x100000L;
    @Property(label="TTL", description="TTL for all entries in this cache in seconds. Default to -1 meaning no TTL.", longValue={-1L})
    private static final String PROP_TTL = "httpcache.cachestore.memcache.ttl";
    private static final long DEFAULT_TTL = -1L;
    private long ttl;
    @Property(label="Maximum size of this store in MB", description="Default to 10MB. If cache size goes beyond this size, least used entry will be evicted from the cache", longValue={10L})
    private static final String PROP_MAX_SIZE_IN_MB = "httpcache.cachestore.memcache.maxsize";
    private static final long DEFAULT_MAX_SIZE_IN_MB = 10L;
    private long maxSizeInMb;
    private Cache<CacheKey, MemCachePersistenceObject> cache;

    @Activate
    protected void activate(Map<String, Object> configs) {
        this.ttl = PropertiesUtil.toLong((Object)configs.get(PROP_TTL), (long)-1L);
        this.maxSizeInMb = PropertiesUtil.toLong((Object)configs.get(PROP_MAX_SIZE_IN_MB), (long)10L);
        if (null != this.cache) {
            this.cache.invalidateAll();
            log.info("Mem cache already present. Invalidating the cache and re-initializing it.");
        }
        this.cache = this.ttl != -1L ? CacheBuilder.newBuilder().maximumWeight(this.maxSizeInMb * 0x100000L).weigher(new MemCacheEntryWeigher()).expireAfterWrite(this.ttl, TimeUnit.SECONDS).removalListener(new MemCacheEntryRemovalListener()).recordStats().build() : CacheBuilder.newBuilder().maximumWeight(this.maxSizeInMb * 0x100000L).weigher(new MemCacheEntryWeigher()).removalListener(new MemCacheEntryRemovalListener()).recordStats().build();
        log.info("MemHttpCacheStoreImpl activated / modified.");
    }

    @Deactivate
    protected void deactivate(Map<String, Object> configs) {
        this.cache.invalidateAll();
        log.info("MemHttpCacheStoreImpl deactivated.");
    }

    @Override
    public void put(CacheKey key, CacheContent content) throws HttpCacheDataStreamException {
        this.cache.put(key, new MemCachePersistenceObject().buildForCaching(content.getStatus(), content.getCharEncoding(), content.getContentType(), content.getHeaders(), content.getInputDataStream(), content.getWriteMethod()));
    }

    @Override
    public boolean contains(CacheKey key) {
        return null != this.cache.getIfPresent(key);
    }

    @Override
    public CacheContent getIfPresent(CacheKey key) {
        MemCachePersistenceObject value = this.cache.getIfPresent(key);
        if (null == value) {
            return null;
        }
        value.incrementHitCount();
        return new CacheContent(value.getStatus(), value.getCharEncoding(), value.getContentType(), value.getHeaders(), new ByteArrayInputStream(value.getBytes()), value.getWriteMethod());
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public void invalidate(CacheKey invalidationKey) {
        ConcurrentMap<CacheKey, MemCachePersistenceObject> cacheAsMap = this.cache.asMap();
        for (CacheKey key : cacheAsMap.keySet()) {
            if (!key.isInvalidatedBy(invalidationKey)) continue;
            this.cache.invalidate(key);
        }
    }

    @Override
    public void invalidate(HttpCacheConfig cacheConfig) {
        ConcurrentMap<CacheKey, MemCachePersistenceObject> cacheAsMap = this.cache.asMap();
        for (CacheKey key : cacheAsMap.keySet()) {
            try {
                if (!cacheConfig.knows(key)) continue;
                this.cache.invalidate(key);
            }
            catch (HttpCacheKeyCreationException e) {
                log.error("Could not invalidate HTTP cache. Falling back to full cache invalidation.", (Throwable)e);
                this.invalidateAll();
            }
        }
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Override
    public TempSink createTempSink() {
        return new MemTempSinkImpl();
    }

    @Override
    public String getStoreType() {
        return "MEM";
    }

    public MemHttpCacheStoreImpl() throws NotCompliantMBeanException {
        super(MemCacheMBean.class);
    }

    @Override
    public long getTtl() {
        return this.ttl;
    }

    @Override
    protected Cache<CacheKey, MemCachePersistenceObject> getCache() {
        return this.cache;
    }

    @Override
    protected long getBytesLength(MemCachePersistenceObject cacheObj) {
        return cacheObj.getBytes().length;
    }

    @Override
    protected void addCacheData(Map<String, Object> data, MemCachePersistenceObject cacheObj) {
        int hitCount = cacheObj.getHitCount();
        long size = cacheObj.getBytes().length;
        data.put("Status", cacheObj.getStatus());
        data.put("Size", FileUtils.byteCountToDisplaySize((long)size));
        data.put("Content Type", cacheObj.getContentType());
        data.put("Character Encoding", cacheObj.getCharEncoding());
        data.put("Hits", hitCount);
        data.put("Total Size Served from Cache", FileUtils.byteCountToDisplaySize((long)((long)hitCount * size)));
    }

    @Override
    protected String toString(MemCachePersistenceObject cacheObj) throws CacheMBeanException {
        try {
            return IOUtils.toString((InputStream)new ByteArrayInputStream(cacheObj.getBytes()), (String)cacheObj.getCharEncoding());
        }
        catch (IOException e) {
            throw new CacheMBeanException("Error getting the content from the cacheObject", e);
        }
    }

    @Override
    protected CompositeType getCacheEntryType() throws OpenDataException {
        return new CompositeType("Cache Entry", "Cache Entry", new String[]{"Cache Key", "Status", "Size", "Content Type", "Character Encoding", "Hits", "Total Size Served from Cache"}, new String[]{"Cache Key", "Status", "Size", "Content Type", "Character Encoding", "Hits", "Total Size Served from Cache"}, new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.STRING});
    }

    private static class MemCacheEntryWeigher
    implements Weigher<CacheKey, MemCachePersistenceObject> {
        private MemCacheEntryWeigher() {
        }

        @Override
        public int weigh(CacheKey memCacheKey, MemCachePersistenceObject memCachePersistenceObject) {
            return memCachePersistenceObject.getBytes().length;
        }
    }

    private static class MemCacheEntryRemovalListener
    implements RemovalListener<CacheKey, MemCachePersistenceObject> {
        private static final Logger log = LoggerFactory.getLogger(MemCacheEntryRemovalListener.class);

        private MemCacheEntryRemovalListener() {
        }

        @Override
        public void onRemoval(RemovalNotification<CacheKey, MemCachePersistenceObject> removalNotification) {
            log.debug("Mem cache entry for uri {} removed due to {}", removalNotification.getKey(), (Object)removalNotification.getCause().name());
        }
    }
}

