/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.data.CompositeVariant;
import com.adobe.acs.commons.data.Spreadsheet;
import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.CheckboxComponent;
import com.adobe.acs.commons.mcp.form.FileUploadComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.RadioComponent;
import com.adobe.acs.commons.mcp.model.GenericBlobReport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataImporter
extends ProcessDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(DataImporter.class);
    private static final String PATH = "path";
    private static final String SLASH = "/";
    @FormField(name="Excel File", description="Provide the .xlsx file that defines the nodes being imported", component=FileUploadComponent.class, options={"mimeTypes=application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "required"})
    private transient RequestParameter importFile;
    @FormField(name="Existing action", description="What to do if an asset exists", component=RadioComponent.EnumerationSelector.class, options={"default=create_and_overwrite_properties", "vertical"})
    private MergeMode mergeMode = MergeMode.CREATE_NODES_AND_OVERWRITE_PROPERTIES;
    @FormField(name="Structure node type", description="Type assigned to new nodes (ignored if spreadsheet has a jcr:primaryType column) -- for ordered folders use sling:OrderedFolder", options={"default=sling:Folder"})
    private String defaultNodeType = "sling:Folder";
    @FormField(name="Include jcr:content nodes", description="If checked, jcr:content nodes are created/updated under nodes", component=CheckboxComponent.class)
    private boolean includeJcrContent = false;
    @FormField(name="jcr:content node type", description="Type assigned to new jcr:content child nodes (ignored if spreadsheet has a jcr:content/jcr:primaryType column)", options={"default=nt:unstructured"})
    private String defaultJcrContentType = "nt:unstructured";
    @FormField(name="Convert header names", description="If checked, property names in the header are converted to lower-case and non-compatible characters are converted to underscores", component=CheckboxComponent.class)
    private boolean enableHeaderNameConversion = false;
    @FormField(name="Dry run", description="If checked, no import happens.  Useful for data validation", component=CheckboxComponent.class, options={"checked"})
    boolean dryRunMode = true;
    @FormField(name="Detailed report", description="If checked, information about every asset is recorded", component=CheckboxComponent.class, options={"checked"})
    private boolean detailedReport = true;
    @FormField(name="Import in sorted order", description="If checked, nodes will be imported in the order determined by their paths", component=CheckboxComponent.class, options={"checked"})
    private boolean presortData = true;
    public static final String TOTAL = "Total";
    private EnumMap<ReportColumns, Object> createdNodes = this.trackActivity("Total", "Create", 0);
    private EnumMap<ReportColumns, Object> updatedNodes = this.trackActivity("Total", "Updated", 0);
    private EnumMap<ReportColumns, Object> skippedNodes = this.trackActivity("Total", "Skipped", 0);
    private EnumMap<ReportColumns, Object> noChangeNodes = this.trackActivity("Total", "No Change", 0);
    Spreadsheet data;
    private List<EnumMap<ReportColumns, Object>> reportRows;
    private transient GenericBlobReport report = new GenericBlobReport();

    protected synchronized EnumMap<ReportColumns, Object> trackActivity(String item, String action, Integer count) {
        if (this.reportRows == null) {
            this.reportRows = Collections.synchronizedList(new ArrayList());
        }
        EnumMap<ReportColumns, Object> reportRow = new EnumMap<ReportColumns, Object>(ReportColumns.class);
        reportRow.put(ReportColumns.item, item);
        reportRow.put(ReportColumns.action, action);
        reportRow.put(ReportColumns.count, count);
        this.reportRows.add(reportRow);
        return reportRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementCount(EnumMap<ReportColumns, Object> row, int amt) {
        EnumMap<ReportColumns, Object> enumMap = row;
        synchronized (enumMap) {
            row.put(ReportColumns.count, (Object)((Integer)row.getOrDefault((Object)ReportColumns.count, 0) + amt));
        }
    }

    @Override
    public void init() throws RepositoryException {
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        if (this.data == null && this.importFile != null) {
            try {
                this.data = new Spreadsheet(this.enableHeaderNameConversion, this.importFile, PATH).buildSpreadsheet();
                if (this.presortData) {
                    Collections.sort(this.data.getDataRowsAsCompositeVariants(), (a, b) -> ((CompositeVariant)b.get(PATH)).toString().compareTo(((CompositeVariant)a.get(PATH)).toString()));
                }
                instance.getInfo().setDescription("Import " + this.data.getFileName() + " (" + this.data.getRowCount() + " rows)");
            }
            catch (IOException ex) {
                LOG.error("Unable to process import", (Throwable)ex);
                instance.getInfo().setDescription("Import " + this.data.getFileName() + " (failed)");
                throw new RepositoryException("Unable to parse input file", (Throwable)ex);
            }
        }
        instance.defineCriticalAction("Import Data", rr, this::importData);
    }

    @Override
    public synchronized void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        this.report.setRows(this.reportRows, ReportColumns.class);
        this.report.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    private void importData(ActionManager manager) {
        this.data.getDataRowsAsCompositeVariants().forEach(row -> manager.deferredWithResolver(rr -> {
            String path = ((CompositeVariant)row.get(PATH)).toString();
            Resource r = rr.getResource(path);
            if (r == null) {
                this.handleMissingNode(path, (ResourceResolver)rr, (Map<String, CompositeVariant>)row);
            } else if (this.mergeMode.update) {
                this.updateMetadata(path, (ResourceResolver)rr, (Map<String, CompositeVariant>)row);
            } else {
                this.incrementCount(this.skippedNodes, 1);
                if (this.detailedReport) {
                    this.trackActivity(path, "Skipped", null);
                }
            }
        }));
    }

    public void handleMissingNode(String path, ResourceResolver rr, Map<String, CompositeVariant> row) throws PersistenceException {
        if (this.mergeMode.create) {
            if (!this.dryRunMode) {
                this.createMissingNode(path, rr, row);
            }
            this.incrementCount(this.createdNodes, 1);
            if (this.detailedReport) {
                this.trackActivity(path, "Created", null);
            }
        } else {
            this.incrementCount(this.skippedNodes, 1);
            if (this.detailedReport) {
                this.trackActivity(path, "Skipped missing", null);
            }
        }
    }

    private void createMissingNode(String path, ResourceResolver rr, Map<String, CompositeVariant> row) throws PersistenceException {
        LOG.debug("Start of createMissingNode for node {}", (Object)path);
        String parentPath = StringUtils.substringBeforeLast((String)path, (String)SLASH);
        HashMap<String, String> resourceProperties = new HashMap<String, String>();
        resourceProperties.put("jcr:primaryType", this.defaultNodeType);
        Resource parent = ResourceUtil.getOrCreateResource((ResourceResolver)rr, (String)parentPath, resourceProperties, (String)this.defaultNodeType, (boolean)true);
        String nodeName = StringUtils.substringAfterLast((String)path, (String)SLASH);
        if (!row.containsKey("{http://www.jcp.org/jcr/1.0}primaryType") && !row.containsKey("jcr:primaryType")) {
            row.put("jcr:primaryType", new CompositeVariant<String>(this.defaultNodeType));
        }
        Map<String, Object> nodeProps = this.createPropertyMap(row);
        rr.refresh();
        Resource main = rr.create(parent, nodeName, nodeProps);
        if (this.includeJcrContent) {
            Map<String, Object> jcrContentProps;
            if (!row.containsKey("jcr:content/jcr:primaryType")) {
                row.put("jcr:content/jcr:primaryType", new CompositeVariant<String>(this.defaultJcrContentType));
            }
            if (!(jcrContentProps = this.createJcrContentPropertyMap(row)).isEmpty()) {
                rr.create(main, "jcr:content", jcrContentProps);
            }
        }
        LOG.debug("End of createMissingNode for node {}", (Object)path);
    }

    private void updateMetadata(String path, ResourceResolver rr, Map<String, CompositeVariant> nodeInfo) throws PersistenceException, RepositoryException {
        LOG.debug("Start of updateMetaData");
        Resource resource = rr.getResource(path);
        this.populateMetadataFromRow(resource, this.createPropertyMap(nodeInfo));
        if (this.includeJcrContent) {
            Map<String, Object> jcrContentProps = this.createJcrContentPropertyMap(nodeInfo);
            Resource jcrContent = resource.getChild("jcr:content");
            if (jcrContent == null) {
                if (!jcrContentProps.containsKey("jcr:content/jcr:primaryType")) {
                    jcrContentProps.put("jcr:primaryType", this.defaultJcrContentType);
                }
                rr.create(resource, "jcr:content", jcrContentProps);
            } else {
                this.populateMetadataFromRow(jcrContent, jcrContentProps);
            }
        }
        if (rr.hasChanges()) {
            this.incrementCount(this.updatedNodes, 1);
            if (this.detailedReport) {
                this.trackActivity(path, "Updated Properties", null);
            }
            if (!this.dryRunMode) {
                rr.commit();
            }
            rr.revert();
            rr.refresh();
        } else {
            if (this.detailedReport) {
                this.trackActivity(path, "No Change", null);
            }
            this.incrementCount(this.noChangeNodes, 1);
        }
        LOG.debug("End of updateMetadata");
    }

    private void appendArray(ModifiableValueMap resourceProperties, Map.Entry entry) {
        Object[] currentArray = (Object[])resourceProperties.get((String)entry.getKey(), Object[].class);
        ArrayList<Object> currentList = new ArrayList<Object>(Arrays.asList(currentArray));
        currentList.addAll(Arrays.asList((Object[])entry.getValue()));
        resourceProperties.put((Object)((String)entry.getKey()), (Object)currentList.toArray());
    }

    private void populateMetadataFromRow(Resource resource, Map<String, Object> nodeInfo) throws RepositoryException {
        LOG.debug("Start of populateMetadataFromRow");
        ModifiableValueMap resourceProperties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        Node node = (Node)resource.adaptTo(Node.class);
        for (Map.Entry<String, Object> entry : nodeInfo.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || !this.mergeMode.overwriteProps && resourceProperties.containsKey((Object)key)) continue;
            if (node.hasProperty(key) && node.getProperty(key).isMultiple() && this.mergeMode.appendArrays) {
                this.appendArray(resourceProperties, entry);
                continue;
            }
            if (value == null) continue;
            resourceProperties.put((Object)key, value);
        }
        LOG.debug("End of populateMetadataFromRow");
    }

    private Map<String, Object> createPropertyMap(Map<String, CompositeVariant> row) {
        return row.entrySet().stream().filter(e -> !((String)e.getKey()).equals("~~ROWNUM~~") && !((String)e.getKey()).equals(PATH) && e.getValue() != null && !((String)e.getKey()).contains(SLASH)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((CompositeVariant)e.getValue()).toPropertyValue()));
    }

    private Map<String, Object> createJcrContentPropertyMap(Map<String, CompositeVariant> row) {
        return row.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("jcr:content")).collect(Collectors.toMap(e -> ((String)e.getKey()).replace("jcr:content/", ""), e -> ((CompositeVariant)e.getValue()).toPropertyValue()));
    }

    public static enum ReportColumns {
        item,
        action,
        count;

    }

    public static enum MergeMode {
        CREATE_NODES_AND_OVERWRITE_PROPERTIES(true, true, true, false),
        CREATE_NODES_AND_OVERWRITE_PROPERTIES_AND_APPEND_ARRAYS(true, true, true, true),
        CREATE_NODES_AND_MERGE_PROPERTIES(true, true, false, false),
        CREATE_ONLY_SKIP_EXISTING(true, false, false, false),
        OVERWRITE_EXISTING_ONLY(false, true, true, false),
        OVERWRITE_EXISTING_ONLY_AND_APPEND_ARRAYS(false, true, true, true),
        MERGE_EXISTING_ONLY(false, true, false, false),
        DO_NOTHING(false, false, false, false);

        boolean create = false;
        boolean update = false;
        boolean overwriteProps = false;
        boolean appendArrays = false;

        private MergeMode(boolean c, boolean u, boolean o, boolean a) {
            this.create = c;
            this.update = u;
            this.overwriteProps = o;
            this.appendArrays = a;
        }
    }
}

