/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.models;

import com.adobe.acs.commons.redirects.filter.RedirectFilter;
import com.adobe.acs.commons.redirects.models.RedirectMatch;
import com.adobe.acs.commons.redirects.models.RedirectRule;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.api.resource.Resource;

public class RedirectConfiguration {
    private Map<String, RedirectRule> pathRules = new LinkedHashMap<String, RedirectRule>();
    private Map<Pattern, RedirectRule> patternRules = new LinkedHashMap<Pattern, RedirectRule>();
    private String path;
    private String name;
    public static final RedirectConfiguration EMPTY = new RedirectConfiguration();

    private RedirectConfiguration() {
    }

    public RedirectConfiguration(Resource resource, String storageSuffix) {
        this.path = resource.getPath();
        this.name = this.path.replace("/" + storageSuffix, "");
        Collection<RedirectRule> rules = RedirectFilter.getRules(resource);
        for (RedirectRule rule : rules) {
            if (rule.getRegex() != null) {
                this.patternRules.put(rule.getRegex(), rule);
                continue;
            }
            this.pathRules.put(RedirectConfiguration.normalizePath(rule.getSource()), rule);
        }
    }

    public static String normalizePath(String resourcePath) {
        int sep = resourcePath.lastIndexOf(46);
        if (sep != -1 && !resourcePath.startsWith("/content/dam/")) {
            resourcePath = resourcePath.substring(0, sep);
        }
        return resourcePath;
    }

    public Map<String, RedirectRule> getPathRules() {
        return this.pathRules;
    }

    public Map<Pattern, RedirectRule> getPatternRules() {
        return this.patternRules;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public RedirectMatch match(String requestPath) {
        String normalizedPath = RedirectConfiguration.normalizePath(requestPath);
        RedirectMatch match = null;
        RedirectRule rule = this.getPathRules().get(normalizedPath);
        if (rule != null) {
            match = new RedirectMatch(rule, null);
        } else {
            for (Map.Entry<Pattern, RedirectRule> entry : this.getPatternRules().entrySet()) {
                Matcher m = entry.getKey().matcher(normalizedPath);
                if (!m.matches()) continue;
                match = new RedirectMatch(entry.getValue(), m);
                break;
            }
        }
        return match;
    }
}

