/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.process.impl;

import com.adobe.acs.commons.util.WorkflowHelper;
import com.adobe.acs.commons.workflow.WorkflowPackageManager;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.resource.details.AssetDetails;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"process.label=ACS AEM Commons - Workflow Process - Set Image Orientation"})
public class SetImageOrientationProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(SetImageOrientationProcess.class);
    @Reference
    private WorkflowPackageManager workflowPackageManager;
    @Reference
    private WorkflowHelper workflowHelper;
    private static final String DEFAULT_CONFIG = ">1.1 properties:orientation/landscape\r\n<0.9 properties:orientation/portrait\r\ndefault properties:orientation/square";

    public final void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaDataMap) {
        Configuration config = new Configuration(metaDataMap);
        try {
            ResourceResolver resourceResolver = this.workflowHelper.getResourceResolver(workflowSession);
            TagManager tagManager = (TagManager)resourceResolver.adaptTo(TagManager.class);
            if (tagManager == null) {
                log.error("Unable to adapt to Tag Manager. This step can't do it's work");
                return;
            }
            List<String> payloads = this.workflowPackageManager.getPaths(resourceResolver, (String)workItem.getWorkflowData().getPayload());
            for (String payload : payloads) {
                log.debug("Processing {}", (Object)payload);
                Resource payloadResource = resourceResolver.resolve(payload);
                Asset asset = DamUtil.resolveToAsset((Resource)payloadResource);
                Resource assetResource = null;
                if (asset != null) {
                    assetResource = (Resource)asset.adaptTo(Resource.class);
                }
                if (assetResource != null) {
                    this.processAsset(assetResource, config, tagManager);
                    continue;
                }
                log.warn("Unable to access asset resource for payload [ {} ]", (Object)payload);
            }
        }
        catch (RepositoryException re) {
            log.error("Unable to apply orientation tags for workflow payload [ {} ]", workItem.getWorkflowData().getPayload(), (Object)re);
        }
    }

    private void processAsset(Resource assetResource, Configuration config, TagManager tagManager) {
        AssetDetails assetDetails = new AssetDetails(assetResource);
        String tagId = this.getOrientation(assetDetails, config);
        log.debug("Orientation tag is {}", (Object)tagId);
        if (tagId != null) {
            Tag tag = tagManager.resolve(tagId);
            if (tag != null) {
                this.addTagToResource(assetResource, tag, tagManager);
                log.debug("Orientation tag set");
            } else {
                log.warn("Unable to resolve tag {} - check configuration for Set Image Orientation workflow step", (Object)tagId);
            }
        } else {
            log.warn("Unable to set orientation tag on asset [ {} ]", (Object)assetResource.getPath());
        }
    }

    private void addTagToResource(Resource resource, Tag tag, TagManager tagManager) {
        Resource metadataResource = this.getMetadataResource(resource);
        Object[] currentTags = tagManager.getTags(metadataResource);
        Tag[] updatedTags = (Tag[])ArrayUtils.add((Object[])currentTags, (Object)tag);
        tagManager.setTags(metadataResource, updatedTags, true);
    }

    private Resource getMetadataResource(Resource resource) {
        return resource.getChild("jcr:content/metadata");
    }

    protected String getOrientation(AssetDetails assetDetails, Configuration config) {
        long width = 0L;
        long height = 0L;
        try {
            width = assetDetails.getWidth();
            height = assetDetails.getHeight();
        }
        catch (RepositoryException re) {
            log.warn("Unable to get width / height for asset: {}", (Object)assetDetails.getAsset().getPath());
        }
        log.debug("Width {} Height {}", (Object)width, (Object)height);
        String tagId = null;
        if (width > 0L && height > 0L) {
            float ratio = (float)width / (float)height;
            log.debug("Ratio is {}", (Object)Float.valueOf(ratio));
            tagId = this.getTagId(config, ratio);
        }
        if (tagId == null) {
            log.debug("Couldn't calculate orientation");
        }
        return tagId;
    }

    private String getTagId(Configuration config, float ratio) {
        for (ConfigRule rule : config.getConfig()) {
            if (rule.operator.equals(">") && ratio > rule.limit) {
                return rule.tagId;
            }
            if (rule.operator.equals("<") && ratio < rule.limit) {
                return rule.tagId;
            }
            if (!rule.operator.equals("default")) continue;
            return rule.tagId;
        }
        return null;
    }

    static class ConfigRule {
        private final String operator;
        private final float limit;
        private final String tagId;

        ConfigRule(String operator, float limit, String tagId) {
            this.operator = operator;
            this.limit = limit;
            this.tagId = tagId;
        }
    }

    private class Configuration {
        public static final String DEFAULT = "default";
        public static final String LT = "<";
        public static final String GT = ">";
        private final List<ConfigRule> config;

        public Configuration(MetaDataMap metaDataMap) {
            String processArgs = StringUtils.trim((String)((String)metaDataMap.get("PROCESS_ARGS", (Object)SetImageOrientationProcess.DEFAULT_CONFIG)));
            this.config = new ArrayList<ConfigRule>();
            for (String arg : processArgs.split("\r\n")) {
                String operator;
                String tagId = arg.substring(arg.indexOf(32) + 1);
                String firstPart = arg.substring(0, arg.indexOf(32));
                float limit = 1.0f;
                if (firstPart.equals(DEFAULT)) {
                    operator = firstPart;
                } else {
                    operator = arg.substring(0, 1);
                    limit = Float.parseFloat(firstPart.substring(1));
                }
                ConfigRule rule = new ConfigRule(operator, limit, tagId);
                this.config.add(rule);
                if (operator.equals(DEFAULT)) break;
            }
        }

        public List<ConfigRule> getConfig() {
            return Collections.unmodifiableList(this.config);
        }
    }
}

