/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.designer.impl;

import com.adobe.granite.ui.clientlibs.ClientLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.clientlibs.LibraryType;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;

@SlingServlet(paths={"/apps/acs-commons/components/utilities/designer/clientlibsmanager/options"}, extensions={"json"})
public class OptionsServlet
extends SlingSafeMethodsServlet {
    @Reference
    private transient HtmlLibraryManager libraryManager;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        JsonWriter writer = new JsonWriter((Writer)response.getWriter());
        writer.beginArray();
        String type = request.getRequestPathInfo().getSelectorString();
        if (type != null) {
            try {
                TreeSet<String> categories = new TreeSet<String>();
                LibraryType libraryType = LibraryType.valueOf((String)type.toUpperCase());
                Map libraries = this.libraryManager.getLibraries();
                for (ClientLibrary library : libraries.values()) {
                    String[] libraryCats;
                    if (library.getTypes() == null || !library.getTypes().contains(libraryType) || (libraryCats = library.getCategories()) == null) continue;
                    for (String cat : libraryCats) {
                        categories.add(cat);
                    }
                }
                for (String cat : categories) {
                    writer.beginObject();
                    writer.name("value");
                    writer.value(cat);
                    writer.name("text");
                    writer.value(cat);
                    writer.endObject();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        writer.endArray();
        writer.close();
    }

    protected void bindLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        this.libraryManager = htmlLibraryManager;
    }

    protected void unbindLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        if (this.libraryManager == htmlLibraryManager) {
            this.libraryManager = null;
        }
    }
}

