/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.forms.helpers.impl;

import com.adobe.acs.commons.forms.Form;
import com.adobe.acs.commons.forms.helpers.FormHelper;
import com.adobe.acs.commons.forms.helpers.PostRedirectGetFormHelper;
import com.adobe.acs.commons.forms.helpers.impl.AbstractFormHelperImpl;
import com.adobe.acs.commons.forms.impl.FormImpl;
import com.adobe.acs.commons.json.JsonObjectUtil;
import com.day.cq.wcm.api.Page;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(inherit=true)
@Property(label="Service Ranking", name="service.ranking", intValue={500})
@Service(value={FormHelper.class, PostRedirectGetFormHelper.class})
public class PostRedirectGetFormHelperImpl
extends AbstractFormHelperImpl
implements PostRedirectGetFormHelper {
    private static final Logger log = LoggerFactory.getLogger(PostRedirectGetFormHelperImpl.class);

    @Override
    public final Form getForm(String formName, SlingHttpServletRequest request) {
        return this.getForm(formName, request, null);
    }

    @Override
    public final Form getForm(String formName, SlingHttpServletRequest request, SlingHttpServletResponse response) {
        if (this.doHandlePost(formName, request)) {
            log.debug("Getting FORM [ {} ] from POST parameters", (Object)formName);
            return this.getPostForm(formName, request);
        }
        if (this.doHandleGet(formName, request)) {
            log.debug("Getting FORM [ {} ] from GET parameters", (Object)formName);
            return this.getGetForm(formName, request, response);
        }
        log.debug("Creating empty form for FORM [ {} ]", (Object)formName);
        return new FormImpl(formName, request.getResource().getPath());
    }

    @Override
    public final void sendRedirect(Form form, String path, SlingHttpServletResponse response) throws IOException {
        this.sendRedirect(form, path, null, response);
    }

    @Override
    public final void sendRedirect(Form form, Page page, SlingHttpServletResponse response) throws IOException {
        this.sendRedirect(form, page, null, response);
    }

    @Override
    public final void sendRedirect(Form form, Resource resource, SlingHttpServletResponse response) throws IOException {
        this.sendRedirect(form, resource, null, response);
    }

    @Override
    public void sendRedirect(Form form, String path, String formSelector, SlingHttpServletResponse response) throws IOException {
        String url = this.getRedirectPath(form, path, formSelector);
        response.sendRedirect(url);
    }

    @Override
    public void sendRedirect(Form form, Page page, String formSelector, SlingHttpServletResponse response) throws IOException {
        String url = this.getRedirectPath(form, page, formSelector);
        response.sendRedirect(url);
    }

    @Override
    public void sendRedirect(Form form, Resource resource, String formSelector, SlingHttpServletResponse response) throws IOException {
        String url = this.getRedirectPath(form, resource, formSelector);
        response.sendRedirect(url);
    }

    @Override
    public final void renderForm(Form form, Page page, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        this.sendRedirect(form, page, this.getFormSelector(request), response);
    }

    @Override
    public final void renderForm(Form form, Resource resource, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        this.sendRedirect(form, resource, this.getFormSelector(request), response);
    }

    @Override
    public final void renderForm(Form form, String path, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        this.sendRedirect(form, path, this.getFormSelector(request), response);
    }

    @Override
    public final void renderOtherForm(Form form, String path, String formSelector, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        this.sendRedirect(form, path, formSelector, response);
    }

    @Override
    public final void renderOtherForm(Form form, Page page, String formSelector, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        this.sendRedirect(form, page, formSelector, response);
    }

    @Override
    public final void renderOtherForm(Form form, Resource resource, String formSelector, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        this.sendRedirect(form, resource, formSelector, response);
    }

    protected final boolean doHandle(String formName, SlingHttpServletRequest request) {
        return this.doHandleGet(formName, request) || this.doHandlePost(formName, request);
    }

    protected boolean doHandleGet(String formName, SlingHttpServletRequest request) {
        if (StringUtils.equalsIgnoreCase((String)"GET", (String)request.getMethod())) {
            return StringUtils.isNotBlank((String)request.getParameter(this.getGetLookupKey(formName)));
        }
        return false;
    }

    protected Form getGetForm(String formName, SlingHttpServletRequest request, SlingHttpServletResponse response) {
        Map data = Collections.EMPTY_MAP;
        Map errors = Collections.EMPTY_MAP;
        String requestData = this.getRawFormData(formName, request, response);
        if (StringUtils.isBlank((String)requestData)) {
            return new FormImpl(formName, request.getResource().getPath());
        }
        try {
            Gson gson = new Gson();
            JsonObject jsonData = JsonObjectUtil.toJsonObject(requestData);
            String incomingFormName = JsonObjectUtil.getString(jsonData, "n");
            if (StringUtils.equals((String)incomingFormName, (String)formName)) {
                data = JsonObjectUtil.getOptionalObject(jsonData, "f").map(incomingJsonForm -> (Map)gson.fromJson((JsonElement)incomingJsonForm, Map.class)).orElse(Collections.EMPTY_MAP);
                if (data.size() > 0) {
                    log.debug("Form data: {}", (Object)data);
                }
                if ((errors = JsonObjectUtil.getOptionalObject(jsonData, "e").map(incomingJsonForm -> (Map)gson.fromJson((JsonElement)incomingJsonForm, Map.class)).orElse(Collections.EMPTY_MAP)).size() > 0) {
                    log.debug("Form errors: {}", (Object)data);
                }
            }
        }
        catch (JsonParseException e) {
            log.warn("Cannot parse query parameters for request: {}", (Object)requestData);
            return new FormImpl(formName, request.getResource().getPath());
        }
        return new FormImpl(formName, request.getResource().getPath(), this.getProtectedData(data), this.getProtectedErrors(errors));
    }

    protected String getRawFormData(String formName, SlingHttpServletRequest request, SlingHttpServletResponse response) {
        return this.decode(request.getParameter(this.getGetLookupKey(formName)));
    }

    protected final String getGetLookupKey(String formName) {
        return "f_" + formName;
    }

    protected final String getRedirectPath(Form form, Page page, String formSelector) throws UnsupportedEncodingException {
        return this.getRedirectPath(form, (Resource)page.adaptTo(Resource.class), formSelector);
    }

    protected final String getRedirectPath(Form form, Resource resource, String formSelector) throws UnsupportedEncodingException {
        return this.getRedirectPath(form, resource.getPath() + ".html", formSelector);
    }

    protected String getRedirectPath(Form form, String path, String formSelector) {
        String redirectPath = path;
        redirectPath = redirectPath + this.getSuffix();
        if (StringUtils.isNotBlank((String)formSelector)) {
            redirectPath = redirectPath + "/" + formSelector;
        }
        redirectPath = redirectPath + "?";
        redirectPath = redirectPath + this.getQueryParameters(form);
        return redirectPath;
    }

    protected final String getQueryParameters(Form form) {
        String params = "";
        if ((form = this.clean(form)).hasData() || form.hasErrors()) {
            params = this.getGetLookupKey(form.getName());
            params = params + "=";
            params = params + this.getQueryParameterValue(form);
        }
        return params;
    }

    protected final String getQueryParameterValue(Form form) {
        boolean hasData = false;
        JsonObject jsonData = new JsonObject();
        form = this.clean(form);
        jsonData.addProperty("n", form.getName());
        Gson gson = new Gson();
        if (form.hasData()) {
            JsonObject jsonForm = (JsonObject)gson.toJsonTree(form.getData());
            jsonData.add("f", (JsonElement)jsonForm);
            hasData = true;
        }
        if (form.hasErrors()) {
            JsonObject jsonError = (JsonObject)gson.toJsonTree(form.getErrors());
            jsonData.add("e", (JsonElement)jsonError);
            hasData = true;
        }
        return hasData ? this.encode(jsonData.toString()) : "";
    }
}

