/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.forms.impl;

import com.adobe.acs.commons.forms.FormsRouter;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Properties(value={@Property(name="sling.filter.scope", value={"include"}), @Property(name="filter.order", intValue={0})})
@Service
public class FormsPostRedirectGetFilterImpl
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(FormsPostRedirectGetFilterImpl.class);
    private static final String REQUEST_ATTR_PREVIOUSLY_PROCESSED = FormsPostRedirectGetFilterImpl.class.getName() + "__Previously_Processed";
    @Reference
    private FormsRouter formsRouter;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof SlingHttpServletRequest) || !(servletResponse instanceof SlingHttpServletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)servletRequest;
        SlingHttpServletResponse slingResponse = (SlingHttpServletResponse)servletResponse;
        if (!StringUtils.equals((String)"GET", (String)slingRequest.getMethod()) || !this.formsRouter.hasValidSuffix(slingRequest)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String formSelector = this.formsRouter.getFormSelector(slingRequest);
        if (formSelector == null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (slingRequest.getAttribute(REQUEST_ATTR_PREVIOUSLY_PROCESSED) != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        options.setReplaceSelectors(formSelector);
        options.setReplaceSuffix(slingRequest.getRequestPathInfo().getSuffix());
        if (log.isDebugEnabled()) {
            log.debug("POST-Redirect-GET Form Filter; Internal forward to resource: {} ", (Object)slingRequest.getResource());
            log.debug("POST-Redirect-GET Form Filter; Internal forward to path: {} ", (Object)slingRequest.getResource().getPath());
            log.debug("POST-Redirect-GET Filter; Internal forward w/ replace selectors: {} ", (Object)options.getReplaceSelectors());
            log.debug("POST-Redirect-GET Filter; Internal forward w/ suffix: {} ", (Object)options.getReplaceSuffix());
        }
        slingRequest.setAttribute(REQUEST_ATTR_PREVIOUSLY_PROCESSED, (Object)Boolean.TRUE);
        slingRequest.getRequestDispatcher(slingRequest.getResource(), options).forward((ServletRequest)slingRequest, (ServletResponse)slingResponse);
    }

    public void destroy() {
    }

    protected void bindFormsRouter(FormsRouter formsRouter) {
        this.formsRouter = formsRouter;
    }

    protected void unbindFormsRouter(FormsRouter formsRouter) {
        if (this.formsRouter == formsRouter) {
            this.formsRouter = null;
        }
    }
}

