/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.http.headers.impl;

import com.adobe.acs.commons.http.headers.impl.ResourceBasedDispatcherMaxAgeHeaderFilter;
import java.util.Dictionary;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Dispacher Cache Control Header Property Based - Max Age", description="Adds a Cache-Control max-age header to content based on property value to enable Dispatcher TTL support.", metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Properties(value={@Property(name="webconsole.configurationFactory.nameHint", value={"Property name: {property.name}. Fallback Max Age: {max.age} "}, propertyPrivate=true), @Property(name="dispatcher.filter.engine", value={"sling"}, propertyPrivate=true)})
public class PropertyBasedDispatcherMaxAgeHeaderFilter
extends ResourceBasedDispatcherMaxAgeHeaderFilter {
    private static final Logger log = LoggerFactory.getLogger(PropertyBasedDispatcherMaxAgeHeaderFilter.class);
    @Property(label="Property name", description="Property to check on how long you want to cache this request")
    public static final String PROP_PROPERTY_NAME = "property.name";
    @Property(label="Inherit property value", description="Property value to skip this filter and inherit another lower service ranking dispatcher ttl filter")
    public static final String PROP_INHERIT_PROPERTY_VALUE = "inherit.property.value";
    private String propertyName;
    private String inheritPropertyValue;

    @Override
    protected boolean accepts(HttpServletRequest request) {
        if (!super.accepts(request)) {
            log.debug("Not accepting request because it is not coming from the dispatcher.");
            return false;
        }
        if (request instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
            Resource resource = this.getResource(slingRequest);
            if (resource == null) {
                log.debug("Could not find resource for request, not accepting");
                return false;
            }
            String headerValue = (String)resource.getValueMap().get(this.propertyName, String.class);
            if (!StringUtils.isBlank((String)headerValue) && !this.inheritPropertyValue.equals(headerValue)) {
                log.debug("Found a max age header value for request {} that is not the inherit value, accepting", (Object)resource.getPath());
                return true;
            }
            log.debug("Resource property is blank or INHERIT, not taking this filter ");
            return false;
        }
        return false;
    }

    @Override
    protected String getHeaderValue(HttpServletRequest request) {
        SlingHttpServletRequest slingRequest;
        Resource resource;
        if (request instanceof SlingHttpServletRequest && (resource = this.getResource(slingRequest = (SlingHttpServletRequest)request)) != null) {
            String headerValue = (String)resource.getValueMap().get(this.propertyName, String.class);
            return "max-age=" + headerValue;
        }
        log.debug("An error occurred, falling back to the default max age value of this filter");
        return super.getHeaderValue(request);
    }

    @Override
    protected final void doActivate(ComponentContext context) throws Exception {
        super.doActivate(context);
        Dictionary properties = context.getProperties();
        this.propertyName = PropertiesUtil.toString(properties.get(PROP_PROPERTY_NAME), null);
        if (this.propertyName == null) {
            throw new ConfigurationException(PROP_PROPERTY_NAME, "Property name should be specified.");
        }
        this.inheritPropertyValue = PropertiesUtil.toString(properties.get(PROP_INHERIT_PROPERTY_VALUE), (String)"INHERIT");
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[property-name:" + this.propertyName + ",fallback-max-age:" + super.getHeaderValue(null) + "]";
    }
}

