/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.config.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.config.HttpCacheConfigExtension;
import com.adobe.acs.commons.httpcache.config.impl.AbstractKeyValueExtension;
import com.adobe.acs.commons.httpcache.keys.CacheKeyFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={HttpCacheConfigExtension.class, CacheKeyFactory.class}, property={"service.ranking:Integer=50"})
@Designate(ocd=Config.class, factory=true)
public class ResourcePropertiesHttpCacheConfigExtension
extends AbstractKeyValueExtension
implements CacheKeyFactory,
HttpCacheConfigExtension {
    private static final Logger log = LoggerFactory.getLogger(ResourcePropertiesHttpCacheConfigExtension.class);
    private String configName;
    private Map<String, String[]> allowedProperties;
    private String cacheKeyId;

    @Override
    public Map<String, String[]> getAllowedKeyValues() {
        return this.allowedProperties;
    }

    @Override
    public boolean accepts(SlingHttpServletRequest request, HttpCacheConfig cacheConfig, Map<String, String[]> allowedKeyValues) {
        for (Map.Entry<String, String[]> entry : allowedKeyValues.entrySet()) {
            String key;
            ValueMap properties = request.getResource().getValueMap();
            if (!properties.containsKey((Object)(key = entry.getKey()))) continue;
            log.debug("{} - passed contains key with key {} for resource {}", new Object[]{this.configName, key, request.getResource().getPath()});
            Object[] propertyValues = (String[])properties.get(key, String[].class);
            if (!ArrayUtils.isEmpty((Object[])propertyValues) && !CollectionUtils.containsAny(Arrays.asList((Object[])entry.getValue()), Arrays.asList(propertyValues))) continue;
            log.debug("{} - passed value check with value {} for resource {}", new Object[]{this.configName, entry.getValue(), request.getResource().getPath()});
            return true;
        }
        return false;
    }

    @Override
    protected String getActualValue(String key, SlingHttpServletRequest request) {
        return (String)request.getResource().getValueMap().get(key, String.class);
    }

    @Override
    public String getCacheKeyId() {
        return "[Resource Property: " + this.cacheKeyId + "]";
    }

    @Activate
    public void activate(Config config) {
        this.allowedProperties = new HashMap<String, String[]>();
        this.allowedProperties.put(config.httpcache_config_extension_property(), config.httpcache_config_extension_property_values());
        this.cacheKeyId = UUID.randomUUID().toString();
        this.configName = config.config_name();
    }

    @ObjectClassDefinition(name="ACS AEM Commons - HTTP Cache - Extension - Resource Properties", description="Defines Resource Property names / Resource Property values that will be allowed for this extension (HttpCacheConfig and CacheKeyFactory).")
    public static @interface Config {
        @AttributeDefinition(name="Allowed Property names", description="The Resource Property name to check.")
        public String httpcache_config_extension_property() default "";

        @AttributeDefinition(name="Allowed Property values", description="This request is only accepted for caching when its named resource property (above) contains one of these values. Leave blank for any value.")
        public String[] httpcache_config_extension_property_values() default {};

        @AttributeDefinition(name="Config Name")
        public String config_name() default "";

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "Properties: [ {httpcache.config.extension.property} ] Property values: [ {httpcache.config.extension.property.values} ] Config name: [ {config.name} ]";
    }
}

