/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.invalidator;

import com.adobe.acs.commons.httpcache.engine.HttpCacheEngine;
import com.adobe.acs.commons.httpcache.exception.HttpCacheException;
import com.day.cq.wcm.commons.ReferenceSearch;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - HTTP Cache - Cache invalidation job consumer", description="Consumes job for invalidating the http cache", immediate=true, metatype=true)
@Service
@Property(name="job.topics", value={"com/adobe/acs/commons/httpcache/invalidator/job"}, propertyPrivate=true)
public class HttpCacheInvalidationJobConsumer
implements JobConsumer {
    private static final Logger log = LoggerFactory.getLogger(HttpCacheInvalidationJobConsumer.class);
    @Property(label="Invalidate references", description="Whether to search for references and invalidate them in the cache.", boolValue={false})
    private static final String PROP_REFERENCES = "httpcache.config.invalidation.references";
    private static final boolean DEFAULT_REFERENCES = false;
    private boolean invalidateRefs;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    private volatile HttpCacheEngine httpCacheEngine;
    @Reference
    private ResourceResolverFactory resolverFactory;

    @Activate
    protected void activate(Map<String, Object> configs) {
        this.invalidateRefs = PropertiesUtil.toBoolean((Object)configs.get(PROP_REFERENCES), (boolean)false);
    }

    public JobConsumer.JobResult process(Job job) {
        String path = (String)job.getProperty("path");
        if (StringUtils.isEmpty((String)path)) {
            log.error("Invalidation job doesn't have path information.");
            return JobConsumer.JobResult.CANCEL;
        }
        this.invalidate(path);
        if (this.invalidateRefs) {
            this.invalidateReferences(path);
        }
        log.trace("Invalidation job for the path [ {} ] processed.", (Object)path);
        return JobConsumer.JobResult.OK;
    }

    void invalidate(String path) {
        if (this.httpCacheEngine.isPathPotentialToInvalidate(path)) {
            try {
                log.debug("invalidating {}", (Object)path);
                this.httpCacheEngine.invalidateCache(path);
            }
            catch (HttpCacheException e) {
                log.debug("Job with the payload path - {} has invalidated the cache", (Object)path);
            }
        }
    }

    void invalidateReferences(String path) {
        try (ResourceResolver adminResolver = this.resolverFactory.getServiceResourceResolver(null);){
            Collection refs = new ReferenceSearch().search(adminResolver, path).values();
            for (ReferenceSearch.Info info : refs) {
                String refPath = info.getPage().getPath();
                this.invalidate(refPath);
            }
        }
        catch (Exception e) {
            log.debug("failed to invalidate references of {}", (Object)path);
        }
    }

    protected void bindHttpCacheEngine(HttpCacheEngine httpCacheEngine) {
        this.httpCacheEngine = httpCacheEngine;
    }

    protected void unbindHttpCacheEngine(HttpCacheEngine httpCacheEngine) {
        if (this.httpCacheEngine == httpCacheEngine) {
            this.httpCacheEngine = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

