/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.images.transformers.impl.composites;

import com.adobe.acs.commons.images.transformers.impl.composites.contexts.MultiplyCompositeContext;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.RasterFormatException;

public class MultiplyBlendComposite
implements Composite {
    private static final DirectColorModel COLOR_MODEL = (DirectColorModel)ColorModel.getRGBdefault();
    private final float alpha;

    public MultiplyBlendComposite(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        if (!MultiplyBlendComposite.isValidColorModel(srcColorModel) || !MultiplyBlendComposite.isValidColorModel(dstColorModel)) {
            throw new RasterFormatException("Invalid color model provided.");
        }
        return new MultiplyCompositeContext(this.alpha);
    }

    private static boolean isValidColorModel(ColorModel cm) {
        if (!(cm instanceof DirectColorModel)) {
            return false;
        }
        DirectColorModel dcm = (DirectColorModel)cm;
        return dcm.getAlphaMask() == COLOR_MODEL.getAlphaMask() && dcm.getRedMask() == COLOR_MODEL.getRedMask() && dcm.getGreenMask() == COLOR_MODEL.getGreenMask() && dcm.getBlueMask() == COLOR_MODEL.getBlueMask();
    }
}

