/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.models.injectors.impl;

import com.adobe.acs.commons.models.injectors.annotation.SharedValueMapValue;
import com.adobe.acs.commons.models.injectors.impl.InjectorUtils;
import com.adobe.acs.commons.util.impl.ReflectionUtil;
import com.adobe.acs.commons.wcm.properties.shared.SharedComponentProperties;
import com.adobe.acs.commons.wcm.properties.shared.SharedValueMapResourceAdapter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.servlet.ServletRequest;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Property(name="service.ranking", intValue={4500})
public class SharedValueMapValueInjector
implements Injector {
    private static final Logger LOG = LoggerFactory.getLogger(SharedValueMapValueInjector.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private SharedComponentProperties sharedComponentProperties;

    @Activate
    protected void activate() {
        if (this.sharedComponentProperties == null) {
            LOG.info("SharedComponentProperties is not active. @SharedValueMapValue model annotations will not have access to global or shared properties.");
        } else {
            LOG.info("SharedComponentProperties is active. @SharedValueMapValue model annotations are fully operational.");
        }
    }

    public String getName() {
        return "shared-component-properties-valuemap";
    }

    public Object getValue(Object adaptable, String name, Type declaredType, AnnotatedElement element, DisposalCallbackRegistry callbackRegistry) {
        if (element.getAnnotation(SharedValueMapValue.class) == null) {
            return null;
        }
        ValueMap valueMap = this.sharedComponentProperties != null ? this.getValueMap(adaptable, element) : (this.getValueType(element) == SharedComponentProperties.ValueTypes.MERGED ? Optional.ofNullable(InjectorUtils.getResource(adaptable)).map(Resource::getValueMap).orElse(ValueMap.EMPTY) : ValueMap.EMPTY);
        return ReflectionUtil.convertValueMapValue(valueMap, name, declaredType);
    }

    private ValueMap getValueMap(Object adaptable, AnnotatedElement element) {
        ValueMap fromBindings;
        SharedComponentProperties.ValueTypes valueType = this.getValueType(element);
        if (valueType == null) {
            return ValueMap.EMPTY;
        }
        Resource resource = InjectorUtils.getResource(adaptable);
        if (resource == null) {
            return ValueMap.EMPTY;
        }
        String rootPagePath = this.sharedComponentProperties.getSharedPropertiesPagePath(resource);
        if (rootPagePath == null) {
            return valueType == SharedComponentProperties.ValueTypes.MERGED ? resource.getValueMap() : ValueMap.EMPTY;
        }
        SlingBindings bindings = this.getBindings(adaptable);
        if (bindings != null && (fromBindings = this.getValueMapFromBindings(bindings, valueType, resource, rootPagePath)) != null) {
            return fromBindings;
        }
        SharedValueMapResourceAdapter adapter = (SharedValueMapResourceAdapter)resource.adaptTo(SharedValueMapResourceAdapter.class);
        switch (valueType) {
            case GLOBAL: {
                return Optional.ofNullable(adapter).map(SharedValueMapResourceAdapter::getGlobalProperties).orElseGet(() -> this.getGlobalProperties(resource));
            }
            case SHARED: {
                return Optional.ofNullable(adapter).map(SharedValueMapResourceAdapter::getSharedProperties).orElseGet(() -> this.getSharedProperties(resource));
            }
            case MERGED: {
                return Optional.ofNullable(adapter).map(SharedValueMapResourceAdapter::getMergedProperties).orElseGet(() -> this.getMergedProperties(resource));
            }
        }
        return ValueMap.EMPTY;
    }

    private ValueMap getValueMapFromBindings(SlingBindings bindings, SharedComponentProperties.ValueTypes valueType, Resource resource, String rootPagePath) {
        if (valueType == SharedComponentProperties.ValueTypes.MERGED && resource.getPath().equals(bindings.get((Object)"mergedPropertiesPath"))) {
            return Optional.ofNullable((ValueMap)bindings.get((Object)"mergedProperties")).orElse(ValueMap.EMPTY);
        }
        if (!rootPagePath.equals(bindings.get((Object)"sharedPropertiesPagePath"))) {
            return null;
        }
        ValueMap globalVmBound = (ValueMap)bindings.get((Object)"globalProperties");
        if (valueType == SharedComponentProperties.ValueTypes.GLOBAL) {
            return Optional.ofNullable(globalVmBound).orElse(ValueMap.EMPTY);
        }
        String sharedPropertiesPath = this.sharedComponentProperties.getSharedPropertiesPath(resource);
        if (sharedPropertiesPath == null) {
            if (valueType == SharedComponentProperties.ValueTypes.SHARED) {
                return ValueMap.EMPTY;
            }
            return this.sharedComponentProperties.mergeProperties(globalVmBound, null, resource);
        }
        ValueMap sharedVmBound = sharedPropertiesPath.equals(bindings.get((Object)"sharedPropertiesPath")) ? (ValueMap)bindings.get((Object)"sharedProperties") : Optional.ofNullable(resource.getResourceResolver().getResource(sharedPropertiesPath)).map(Resource::getValueMap).orElse(ValueMap.EMPTY);
        if (valueType == SharedComponentProperties.ValueTypes.SHARED) {
            return Optional.ofNullable(sharedVmBound).orElse(ValueMap.EMPTY);
        }
        return this.sharedComponentProperties.mergeProperties(globalVmBound, sharedVmBound, resource);
    }

    private SharedComponentProperties.ValueTypes getValueType(AnnotatedElement element) {
        return element.getAnnotation(SharedValueMapValue.class).type();
    }

    private SlingBindings getBindings(Object adaptable) {
        if (adaptable instanceof ServletRequest) {
            ServletRequest request = (ServletRequest)adaptable;
            return (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        }
        return null;
    }

    protected ValueMap getSharedProperties(Resource resource) {
        return Optional.ofNullable(this.sharedComponentProperties).map(scp -> scp.getSharedProperties(resource)).orElse(ValueMap.EMPTY);
    }

    protected ValueMap getGlobalProperties(Resource resource) {
        return Optional.ofNullable(this.sharedComponentProperties).map(scp -> scp.getGlobalProperties(resource)).orElse(ValueMap.EMPTY);
    }

    protected ValueMap getMergedProperties(Resource resource) {
        return Optional.ofNullable(this.sharedComponentProperties).map(scp -> scp.mergeProperties(this.getGlobalProperties(resource), this.getSharedProperties(resource), resource)).orElse(resource.getValueMap());
    }

    protected void bindSharedComponentProperties(SharedComponentProperties sharedComponentProperties) {
        this.sharedComponentProperties = sharedComponentProperties;
    }

    protected void unbindSharedComponentProperties(SharedComponentProperties sharedComponentProperties) {
        if (this.sharedComponentProperties == sharedComponentProperties) {
            this.sharedComponentProperties = null;
        }
    }
}

