/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.servlets;

import com.adobe.acs.commons.redirects.filter.RedirectFilter;
import com.adobe.acs.commons.redirects.models.RedirectRule;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, immediate=true, name="ImportRedirectMapServlet", property={"sling.servlet.label=ACS AEM Commons - Import Redirects Servlet", "sling.servlet.methods=POST", "sling.servlet.selectors=import", "sling.servlet.resourceTypes=acs-commons/components/utilities/manage-redirects"})
public class ImportRedirectMapServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(ImportRedirectMapServlet.class);
    private static final long serialVersionUID = -3564475196678277711L;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Map xlsRules;
        String path = request.getParameter("path");
        Resource storageRoot = request.getResourceResolver().getResource(path);
        log.debug("Updating redirect maps at {}", (Object)storageRoot.getPath());
        Map jcrRules = RedirectFilter.getRules(storageRoot).stream().collect(Collectors.toMap(RedirectRule::getSource, r -> r, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        InputStream is = ImportRedirectMapServlet.getFile(request);
        Object object = null;
        try {
            xlsRules = this.readEntries(is).stream().collect(Collectors.toMap(RedirectRule::getSource, r -> r, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (object != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        ArrayList<RedirectRule> rules = new ArrayList<RedirectRule>();
        for (RedirectRule jcrRule : jcrRules.values()) {
            if (xlsRules.containsKey(jcrRule.getSource())) {
                jcrRule = (RedirectRule)xlsRules.remove(jcrRule.getSource());
            }
            rules.add(jcrRule);
        }
        rules.addAll(xlsRules.values());
        if (!rules.isEmpty()) {
            this.update(storageRoot, rules);
        }
    }

    void update(Resource root, Collection<RedirectRule> rules) throws PersistenceException {
        ResourceResolver resolver = root.getResourceResolver();
        for (Resource res : root.getChildren()) {
            if (!"acs-commons/components/utilities/manage-redirects/redirect-row".equals(res.getResourceType())) continue;
            resolver.delete(res);
        }
        int idx = 0;
        for (RedirectRule rule : rules) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("source", rule.getSource());
            props.put("target", rule.getTarget());
            props.put("statusCode", String.valueOf(rule.getStatusCode()));
            if (rule.getUntilDate() != null) {
                props.put("untilDate", GregorianCalendar.from(rule.getUntilDate()));
            }
            if (rule.getNote() != null) {
                props.put("note", rule.getNote());
            }
            props.put("sling:resourceType", "acs-commons/components/utilities/manage-redirects/redirect-row");
            props.put("jcr:created", Calendar.getInstance());
            props.put("jcr:createdBy", resolver.getUserID());
            resolver.create(root, "redirect-rule-" + ++idx, props);
        }
        resolver.commit();
    }

    Collection<RedirectRule> readEntries(InputStream is) throws IOException {
        LinkedHashSet<RedirectRule> rules = new LinkedHashSet<RedirectRule>();
        XSSFWorkbook wb = new XSSFWorkbook(is);
        Sheet sheet = wb.getSheetAt(0);
        boolean first = true;
        for (Row row : sheet) {
            if (!first) {
                String source = row.getCell(0).getStringCellValue();
                String target = row.getCell(1).getStringCellValue();
                int statusCode = (int)row.getCell(2).getNumericCellValue();
                Cell c4 = row.getCell(3);
                GregorianCalendar untilDate = null;
                if (DateUtil.isCellDateFormatted((Cell)c4)) {
                    try {
                        Instant instant = DateUtil.getJavaDate((double)c4.getNumericCellValue()).toInstant();
                        ZonedDateTime zdate = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
                        untilDate = GregorianCalendar.from(zdate);
                    }
                    catch (Exception e) {
                        log.error("cannot set data from {}", (Object)c4.toString(), (Object)e);
                    }
                }
                Cell c5 = row.getCell(4);
                String note = null;
                if (c5 != null) {
                    note = c5.getStringCellValue();
                }
                rules.add(new RedirectRule(source, target, statusCode, untilDate, note));
                continue;
            }
            first = false;
        }
        log.debug("{} rules read from spreadsheet", (Object)rules.size());
        return rules;
    }

    public static InputStream getFile(SlingHttpServletRequest request) throws IOException {
        InputStream stream = null;
        for (RequestParameter param : request.getRequestParameterList()) {
            if (param.isFormField()) continue;
            stream = param.getInputStream();
            break;
        }
        return stream;
    }
}

