/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.models;

import com.adobe.acs.commons.reports.api.ReportException;
import com.adobe.acs.commons.reports.api.ReportExecutor;
import com.adobe.acs.commons.reports.api.ResultsPage;
import com.adobe.acs.commons.reports.models.QueryReportConfig;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class QueryReportExecutor
implements ReportExecutor {
    private static final Logger log = LoggerFactory.getLogger(QueryReportExecutor.class);
    private QueryReportConfig config;
    private int page;
    private SlingHttpServletRequest request;
    private String statement;

    public QueryReportExecutor(SlingHttpServletRequest request) {
        this.request = request;
    }

    private ResultsPage fetchResults(int limit, int offset) throws ReportException {
        this.prepareStatement();
        try {
            ResourceResolver resolver = this.request.getResourceResolver();
            QueryManager queryMgr = ((Session)Optional.ofNullable(resolver.adaptTo(Session.class)).orElseThrow(() -> new ReportException("Failed to get JCR Session"))).getWorkspace().getQueryManager();
            Query query = queryMgr.createQuery(this.statement, this.config.getQueryLanguage());
            if (this.page != -1) {
                log.debug("Fetching results with limit {} and offset {}", (Object)limit, (Object)offset);
                query.setLimit((long)limit);
                query.setOffset((long)offset);
            } else {
                log.debug("Fetching all results");
            }
            QueryResult result = query.execute();
            NodeIterator nodes = result.getNodes();
            Spliterator spliterator = Spliterators.spliteratorUnknownSize(nodes, 272);
            Stream<Resource> results = StreamSupport.stream(spliterator, false).map(n -> this.getResource((Node)n, resolver));
            return new ResultsPage(results, this.config.getPageSize(), this.page, nodes.getSize());
        }
        catch (RepositoryException re) {
            throw new ReportException("Exception executing search results", re);
        }
    }

    @Override
    public ResultsPage getAllResults() throws ReportException {
        return this.fetchResults(Integer.MAX_VALUE, 0);
    }

    @Override
    public String getDetails() throws ReportException {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
        details.put("Language", this.config.getQueryLanguage());
        details.put("Page", Integer.toString(this.page));
        details.put("Page Size", Integer.toString(this.config.getPageSize()));
        details.put("Query", this.statement);
        try {
            QueryManager queryManager = ((Session)Optional.ofNullable(this.request.getResourceResolver().adaptTo(Session.class)).orElseThrow(() -> new ReportException("Failed to get JCR Session"))).getWorkspace().getQueryManager();
            Query query = queryManager.createQuery("explain " + this.statement, this.config.getQueryLanguage());
            QueryResult queryResult = query.execute();
            RowIterator rows = queryResult.getRows();
            while (rows.hasNext()) {
                Row row = rows.nextRow();
                String[] cols = queryResult.getColumnNames();
                Value[] values = row.getValues();
                for (int i = 0; i < cols.length; ++i) {
                    details.put(cols[i], values[i].getString());
                }
            }
        }
        catch (RepositoryException re) {
            throw new ReportException("Exception getting details", re);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : details.entrySet()) {
            sb.append("<dt>" + StringEscapeUtils.escapeHtml((String)((String)entry.getKey())) + "</dt>");
            sb.append("<dd>" + StringEscapeUtils.escapeHtml((String)((String)entry.getValue())) + "</dd>");
        }
        return "<dl>" + sb.toString() + "</dl>";
    }

    @Override
    public String getParameters() throws ReportException {
        ArrayList<String> params = new ArrayList<String>();
        Enumeration keys = this.request.getParameterNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            for (String value : this.request.getParameterValues(key)) {
                try {
                    params.add(URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new ReportException("UTF-8 encoding available", e);
                }
            }
        }
        return StringUtils.join(params, (String)"&");
    }

    private Resource getResource(Node node, ResourceResolver resolver) {
        try {
            return resolver.getResource(node.getPath());
        }
        catch (RepositoryException e) {
            log.warn("Failed to get path from node: {}", (Object)node, (Object)e);
            return null;
        }
    }

    @Override
    public ResultsPage getResults() throws ReportException {
        return this.fetchResults(this.config.getPageSize(), this.config.getPageSize() * this.page);
    }

    private void prepareStatement() throws ReportException {
        try {
            Map<String, String> parameters = this.getParamPatternMap(this.request);
            Template template = new Handlebars().compileInline(this.config.getQuery());
            this.statement = template.apply(parameters);
            log.trace("Loaded statement: {}", (Object)this.statement);
        }
        catch (IOException ioe) {
            throw new ReportException("Exception templating query", ioe);
        }
    }

    @Override
    public void setConfiguration(Resource config) {
        this.config = (QueryReportConfig)config.adaptTo(QueryReportConfig.class);
    }

    @Override
    public void setPage(int page) {
        this.page = page;
    }
}

