/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.sorter.impl;

import com.adobe.acs.commons.sorter.NodeSorter;
import com.adobe.acs.commons.sorter.impl.HierarchyNodeComparator;
import com.day.cq.commons.JcrLabeledResource;
import java.util.Comparator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;

@Component
public class NodeTitleSorter
implements NodeSorter {
    public static final String SORTER_NAME = "byTitle";
    public static final String RP_CASE_SENSITIVE = ":caseSensitive";

    @Override
    public String getName() {
        return SORTER_NAME;
    }

    @Override
    public String getLabel() {
        return "By Node Title";
    }

    @Override
    public Comparator<Node> createComparator(HttpServletRequest request) {
        boolean caseSensitive = Boolean.parseBoolean(request.getParameter(RP_CASE_SENSITIVE));
        boolean nonHierarchyFirst = request.getParameter(":nonHierarchyFirst") == null || Boolean.parseBoolean(request.getParameter(":nonHierarchyFirst"));
        Comparator<Node> parentComparator = nonHierarchyFirst ? HierarchyNodeComparator.INSTANCE : (n1, n2) -> 0;
        return parentComparator.thenComparing((n1, n2) -> {
            try {
                String title2;
                String title1 = new JcrLabeledResource(n1).getTitle();
                if (title1 == null) {
                    title1 = n1.getName();
                }
                if ((title2 = new JcrLabeledResource(n2).getTitle()) == null) {
                    title2 = n2.getName();
                }
                return caseSensitive ? title1.compareTo(title2) : title1.compareToIgnoreCase(title2);
            }
            catch (RepositoryException e) {
                return 0;
            }
        });
    }
}

