/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.version.model;

import com.adobe.acs.commons.version.EvolutionAnalyser;
import com.adobe.acs.commons.version.EvolutionContext;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.models.annotations.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class EvolutionModel {
    private static final Logger log = LoggerFactory.getLogger(EvolutionModel.class);
    @Inject
    private ResourceResolver resolver;
    @Inject
    private EvolutionAnalyser analyser;
    private final String path;

    public EvolutionModel(SlingHttpServletRequest request) {
        this.path = request.getParameter("path");
    }

    public String getResourcePath() {
        return this.path;
    }

    public EvolutionContext getEvolution() {
        if (StringUtils.isNotEmpty((String)this.path)) {
            Resource resource = this.resolver.resolve(this.path);
            if (resource != null && !ResourceUtil.isNonExistingResource((Resource)resource)) {
                return this.analyser.getEvolutionContext(resource);
            }
            log.warn("Could not resolve resource at path={}", (Object)this.path);
        }
        log.warn("No path provided");
        return null;
    }
}

