/*
 * #%L
 * ACS AEM Commons Bundle
 * %%
 * Copyright (C) 2013 Adobe
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/*global angular: false, quickly: false */

quickly.filter('title', function() {
    return function(haystack, needle) {
        var filtered = [];

        if(!needle || needle.trim() === '') {
            return haystack;
        }

        haystack.forEach(function(result){
            if(result.title && result.title.toLowerCase().indexOf(needle.toLowerCase()) > -1) {
                filtered.push(result);
            }
        });

        return filtered;
    };
});