/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.clientlib_optimizer.impl;

import com.adobe.acs.tools.clientlib_optimizer.impl.ClientLibraryDependency;
import com.adobe.acs.tools.clientlib_optimizer.impl.ClientLibraryPathComparator;
import com.adobe.granite.ui.clientlibs.ClientLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.clientlibs.LibraryType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class ClientLibOptimizerServlet
extends SlingSafeMethodsServlet {
    private static final String PARAM_LIBRARY_TYPE_CSS = "css";
    private static final String PARAM_LIBRARY_TYPE_JS = "js";
    private static final String PARAM_CATEGORIES = "categories";
    private HtmlLibraryManager htmlLibraryManager;

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        HashMap<LibraryType, Boolean> types = new HashMap<LibraryType, Boolean>();
        types.put(LibraryType.JS, this.hasLibraryTypeParam(request, PARAM_LIBRARY_TYPE_JS));
        types.put(LibraryType.CSS, this.hasLibraryTypeParam(request, PARAM_LIBRARY_TYPE_CSS));
        List<String> categories = this.getCategories(this.getCategoriesParam(request), types);
        try {
            this.writeJsonResponse(categories, response);
        }
        catch (JSONException e) {
            throw new ServletException("Error constructing valid JSON response.");
        }
    }

    private Set<String> getCategoriesParam(SlingHttpServletRequest request) {
        LinkedHashSet<String> categories = new LinkedHashSet<String>();
        RequestParameter requestParameter = request.getRequestParameter(PARAM_CATEGORIES);
        if (requestParameter != null) {
            String[] segments;
            for (String segment : segments = StringUtils.split((String)requestParameter.getString(), (String)",")) {
                if (!StringUtils.isNotBlank((String)segment)) continue;
                categories.add(StringUtils.stripToEmpty((String)segment));
            }
        }
        return categories;
    }

    private boolean hasLibraryTypeParam(SlingHttpServletRequest request, String paramLibraryType) {
        RequestParameter requestParameter = request.getRequestParameter(paramLibraryType);
        if (requestParameter != null) {
            return Boolean.parseBoolean(requestParameter.getString());
        }
        return false;
    }

    private void writeJsonResponse(List<String> categories, SlingHttpServletResponse response) throws JSONException, IOException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(PARAM_CATEGORIES, (Object)new JSONArray(categories));
        response.getWriter().print(jsonObject.toString());
    }

    private List<String> getSortedDependentCategories(Set<String> originalCategories, LibraryType type, List<String> existingCategories) {
        Collection libraries = this.htmlLibraryManager.getLibraries(originalCategories.toArray(new String[0]), null, true, false);
        return ClientLibOptimizerServlet.getSortedDependentCategories(libraries, originalCategories, type, existingCategories);
    }

    static List<String> getSortedDependentCategories(Collection<ClientLibrary> libraries, Set<String> requestedCategories, LibraryType type, List<String> existingCategories) {
        ArrayList<ClientLibrary> sortedLibraries = new ArrayList<ClientLibrary>(libraries);
        Collections.sort(sortedLibraries, new ClientLibraryPathComparator());
        for (ClientLibrary library : libraries) {
            int index = existingCategories.isEmpty() ? 0 : existingCategories.size();
            ClientLibraryDependency dependency = new ClientLibraryDependency(null, library, requestedCategories, false, type);
            existingCategories = dependency.buildDependencyTree(existingCategories, index);
        }
        return existingCategories;
    }

    private List<String> getCategories(Set<String> originalCategories, Map<LibraryType, Boolean> types) {
        List<String> categories = new ArrayList<String>();
        if (types.get(LibraryType.JS).booleanValue()) {
            categories = this.getSortedDependentCategories(originalCategories, LibraryType.JS, categories);
        }
        if (types.get(LibraryType.CSS).booleanValue()) {
            categories = this.getSortedDependentCategories(originalCategories, LibraryType.CSS, categories);
        }
        return categories;
    }

    protected void bindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        this.htmlLibraryManager = htmlLibraryManager;
    }

    protected void unbindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        if (this.htmlLibraryManager == htmlLibraryManager) {
            this.htmlLibraryManager = null;
        }
    }
}

