/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.clientlib_optimizer.impl;

import com.adobe.acs.tools.clientlib_optimizer.impl.DependencyLoopException;
import com.adobe.granite.ui.clientlibs.ClientLibrary;
import com.adobe.granite.ui.clientlibs.LibraryType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientLibraryDependency {
    private final ClientLibrary library;
    private final ClientLibraryDependency parent;
    private final LibraryType type;
    private final boolean isEmbed;
    private final SortedSet<String> requestedCategories;
    private static final Logger log = LoggerFactory.getLogger(ClientLibraryDependency.class);

    public ClientLibraryDependency(ClientLibraryDependency parent, ClientLibrary library, Set<String> requestedCategories, boolean isEmbed, LibraryType type) {
        this.library = library;
        this.parent = parent;
        if (ClientLibraryDependency.isDependencyLoop(parent, library.getPath())) {
            throw new DependencyLoopException("Dependency loop detected: " + ClientLibraryDependency.getStackTrace(parent, library.getPath()));
        }
        this.type = type;
        this.isEmbed = isEmbed;
        this.requestedCategories = new TreeSet(Collections.reverseOrder());
        for (String category : library.getCategories()) {
            if (!requestedCategories.contains(category)) continue;
            this.requestedCategories.add(category);
        }
    }

    public List<String> buildDependencyTree(List<String> categories, int currentPosition) {
        log.debug("Giving out dependencies for {}", (Object)ClientLibraryDependency.getStackTrace(this.parent, this.library.getPath()));
        if (this.library.getTypes().contains(this.type)) {
            for (String category : this.requestedCategories) {
                if (categories.contains(category)) {
                    log.debug("Category {} already in list, not adding twice!", (Object)category, (Object)this.library.getPath());
                    if (currentPosition < categories.indexOf(category)) {
                        categories.remove(category);
                        categories.add(currentPosition, category);
                        log.debug("Move category {} to the current position because it is needed earlier!", (Object)category);
                        continue;
                    }
                    log.debug("No need to move category because it is loaded early enough!");
                    currentPosition = categories.indexOf(category);
                    continue;
                }
                categories.add(currentPosition, category);
            }
        } else {
            log.debug("Not considering categories of this client library because they have the wrong type {}, request was type {}", (Object)this.library.getTypes(), (Object)this.type);
        }
        log.debug("Processing embedded JS libraries of library with path {}", (Object)this.library.getPath());
        this.addLibraries(categories, true, this.library.getEmbedded(LibraryType.JS), this.library.getEmbeddedCategories(), currentPosition);
        log.debug("Processing embedded CSS libraries of library with path {}", (Object)this.library.getPath());
        this.addLibraries(categories, true, this.library.getEmbedded(LibraryType.CSS), this.library.getEmbeddedCategories(), currentPosition);
        log.debug("Processing dependent libraries of library with path {}", (Object)this.library.getPath());
        this.addLibraries(categories, false, this.library.getDependencies(false), this.library.getDependentCategories(), currentPosition);
        return categories;
    }

    private List<String> addLibraries(List<String> categories, boolean isEmbed, Map<String, ? extends ClientLibrary> librariesMap, String[] requestedCategories, int currentPosition) {
        TreeMap<String, ? extends ClientLibrary> sortedLibrariesMap = new TreeMap<String, ClientLibrary>(librariesMap);
        for (Map.Entry entry : sortedLibrariesMap.descendingMap().entrySet()) {
            ClientLibraryDependency dependency = new ClientLibraryDependency(this, (ClientLibrary)entry.getValue(), new HashSet<String>(Arrays.asList(requestedCategories)), isEmbed, this.type);
            categories = dependency.buildDependencyTree(categories, currentPosition);
        }
        return categories;
    }

    public static boolean isDependencyLoop(ClientLibraryDependency parent, String path) {
        while (parent != null) {
            if (path.equals(parent.library.getPath())) {
                return true;
            }
            parent = parent.parent;
        }
        return false;
    }

    public static String getStackTrace(ClientLibraryDependency parent, String currentPath) {
        StringBuffer tmp = new StringBuffer();
        ClientLibraryDependency.printStack(tmp, parent);
        tmp.append(currentPath);
        return tmp.toString();
    }

    private static void printStack(StringBuffer buffer, ClientLibraryDependency parent) {
        if (parent != null) {
            ClientLibraryDependency.printStack(buffer, parent.parent);
            buffer.append(parent.toString() + "->");
        }
    }

    public String toString() {
        return this.library.getPath() + "[cat:" + StringUtils.join((Object[])this.library.getCategories()) + ", embed:" + this.isEmbed + ", type: " + this.library.getTypes() + "]";
    }
}

