/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.csv.impl;

import com.adobe.acs.tools.csv.impl.Parameters;
import com.day.text.csv.Csv;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvUtil {
    private static final Logger log = LoggerFactory.getLogger(CsvUtil.class);
    public static final String TERMINATED = "_LINE_TERMINATED";

    public static Iterator<String[]> getRowsFromCsv(Parameters params) throws IOException {
        Csv csv = new Csv();
        InputStream is = params.getFile();
        if (params.getDelimiter() != null) {
            log.debug("Setting Field Delimiter to [ {} ]", (Object)params.getDelimiter());
            csv.setFieldDelimiter(params.getDelimiter().charValue());
        }
        if (params.getSeparator() != null) {
            log.debug("Setting Field Separator to [ {} ]", (Object)params.getSeparator());
            csv.setFieldSeparatorRead(params.getSeparator().charValue());
        }
        is = CsvUtil.terminateLines(is, params.getSeparator() != null ? params.getSeparator().charValue() : csv.getFieldSeparatorRead(), params.getCharset());
        return csv.read(is, params.getCharset());
    }

    public static InputStream terminateLines(InputStream is, char separator, String charset) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(baos);
        LineIterator lineIterator = IOUtils.lineIterator((InputStream)is, (String)charset);
        while (lineIterator.hasNext()) {
            String line = StringUtils.stripToNull((String)lineIterator.next());
            if (line == null) continue;
            line = line + separator + TERMINATED;
            printStream.println(line);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

