/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.csv_asset_importer.impl;

import com.adobe.acs.tools.csv_asset_importer.impl.CsvAssetImportException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.format.ISODateTimeFormat;

public final class Column<T> {
    private static final String MULTI = "multi";
    private String multiDelimiter = "|";
    private String raw;
    private String relPropertyPath;
    private String propertyName;
    private boolean multi = false;
    private Class dataType = String.class;
    private int index = 0;
    private boolean ignore = false;

    public Column(String raw, int index) {
        this.index = index;
        this.raw = StringUtils.trim((String)raw);
        String paramsStr = StringUtils.substringBetween((String)raw, (String)"{{", (String)"}}");
        String[] params = StringUtils.split((String)paramsStr, (String)":");
        if (StringUtils.isBlank((String)paramsStr)) {
            this.relPropertyPath = this.getRaw();
        } else {
            this.relPropertyPath = StringUtils.trim((String)StringUtils.substringBefore((String)this.getRaw(), (String)"{{"));
            if (params.length == 2) {
                this.dataType = this.nameToClass(StringUtils.stripToEmpty((String)params[0]));
                this.multi = StringUtils.equalsIgnoreCase((String)StringUtils.stripToEmpty((String)params[1]), (String)MULTI);
            }
            if (params.length == 1) {
                if (StringUtils.equalsIgnoreCase((String)MULTI, (String)StringUtils.stripToEmpty((String)params[0]))) {
                    this.multi = true;
                } else {
                    this.dataType = this.nameToClass(StringUtils.stripToEmpty((String)params[0]));
                }
            }
        }
        this.propertyName = StringUtils.contains((String)this.relPropertyPath, (String)"/") ? StringUtils.trim((String)StringUtils.substringAfterLast((String)this.relPropertyPath, (String)"/")) : StringUtils.trim((String)this.relPropertyPath);
    }

    public T getData(String data) {
        return this.toObjectType(data, this.getDataType());
    }

    public T[] getMultiData(String data) {
        String[] vals = StringUtils.split((String)data, (String)this.multiDelimiter);
        ArrayList<T> list = new ArrayList<T>();
        for (String val : vals) {
            T obj = this.toObjectType(val, this.getDataType());
            list.add(obj);
        }
        return list.toArray((Object[])Array.newInstance(this.getDataType(), 0));
    }

    public int getJcrPropertyType() {
        if (Calendar.class.equals((Object)this.dataType)) {
            return 5;
        }
        if (Double.class.equals((Object)this.dataType)) {
            return 4;
        }
        if (Long.class.equals((Object)this.dataType)) {
            return 3;
        }
        if (Boolean.class.equals((Object)this.dataType)) {
            return 6;
        }
        return 1;
    }

    protected <T> T toObjectType(String data, Class<T> klass) {
        data = StringUtils.trim((String)data);
        if (Double.class.equals(klass)) {
            try {
                return klass.cast(Double.parseDouble(data));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (Long.class.equals(klass)) {
            try {
                return klass.cast(Long.parseLong(data));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (Integer.class.equals(klass)) {
            try {
                return klass.cast(Long.parseLong(data));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (StringUtils.equalsIgnoreCase((String)"true", (String)data) && Boolean.class.equals(klass)) {
            return klass.cast(Boolean.TRUE);
        }
        if (StringUtils.equalsIgnoreCase((String)"false", (String)data) && Boolean.class.equals(klass)) {
            return klass.cast(Boolean.FALSE);
        }
        if (Date.class.equals(klass) || Calendar.class.equals(klass)) {
            return klass.cast(ISODateTimeFormat.dateTimeParser().parseDateTime(data).toCalendar(Locale.US));
        }
        return klass.cast(data);
    }

    private Class nameToClass(String name) {
        if (StringUtils.equalsIgnoreCase((String)name, (String)"date") || StringUtils.equalsIgnoreCase((String)name, (String)"calendar")) {
            return Calendar.class;
        }
        if (StringUtils.equalsIgnoreCase((String)name, (String)"double")) {
            return Double.class;
        }
        if (StringUtils.equalsIgnoreCase((String)name, (String)"long") || StringUtils.equalsIgnoreCase((String)name, (String)"int") || StringUtils.equalsIgnoreCase((String)name, (String)"integer")) {
            return Long.class;
        }
        if (StringUtils.equalsIgnoreCase((String)name, (String)"boolean")) {
            return Boolean.class;
        }
        return String.class;
    }

    public String getRaw() {
        return this.raw;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getRelPropertyPath() {
        return this.relPropertyPath;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public Class getDataType() {
        return this.dataType;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public void setMultiDelimiter(String multiDelimiter) {
        this.multiDelimiter = multiDelimiter;
    }

    public static Map<String, Column> getColumns(String[] row, String multiDelimiter, String[] ignoreProperties, String[] requiredProperties) throws CsvAssetImportException {
        HashMap<String, Column> map = new HashMap<String, Column>();
        for (int i = 0; i < row.length; ++i) {
            Column col = new Column(row[i], i);
            col.setIgnore(ArrayUtils.contains((Object[])ignoreProperties, (Object)col.getPropertyName()));
            col.setMultiDelimiter(multiDelimiter);
            map.put(col.getPropertyName(), col);
        }
        List<String> missingRequiredProperties = Column.hasRequiredFields(map.values(), requiredProperties);
        if (!missingRequiredProperties.isEmpty()) {
            throw new CsvAssetImportException("Could not find required columns in CSV: " + StringUtils.join(missingRequiredProperties, (String)", "));
        }
        return map;
    }

    private static List<String> hasRequiredFields(Collection<Column> columns, String ... requiredPropertyNames) {
        ArrayList<String> missing = new ArrayList<String>();
        for (String propertyName : requiredPropertyNames) {
            boolean found = false;
            for (Column column : columns) {
                if (!StringUtils.equals((String)propertyName, (String)column.getPropertyName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            missing.add(propertyName);
        }
        return missing;
    }
}

