/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.csv_asset_importer.impl;

import com.adobe.acs.tools.csv_asset_importer.impl.Column;
import com.adobe.acs.tools.csv_asset_importer.impl.CsvAssetImportException;
import com.adobe.acs.tools.csv_asset_importer.impl.Parameters;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.text.csv.Csv;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.mime.MimeTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvAssetImporterServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(CsvAssetImporterServlet.class);
    public static final String TERMINATED = "_LINE_TERMINATED";
    private MimeTypeService mimeTypeService;

    protected final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        JSONObject jsonResponse = new JSONObject();
        Parameters params = new Parameters(request);
        if (params.getFile() != null) {
            long start = System.currentTimeMillis();
            Iterator<String[]> rows = this.getRowsFromCsv(params);
            try {
                String[] requiredProperties = new String[]{params.getAbsTargetPathProperty()};
                Map<String, Column> columns = Column.getColumns(rows.next(), params.getMultiDelimiter(), params.getIgnoreProperties(), requiredProperties);
                ArrayList result = new ArrayList();
                ArrayList<String> batch = new ArrayList<String>();
                ArrayList<String> failures = new ArrayList<String>();
                log.info(params.toString());
                ((Session)request.getResourceResolver().adaptTo(Session.class)).getWorkspace().getObservationManager().setUserData("acs-aem-tools.csv-asset-importer");
                while (rows.hasNext()) {
                    String[] row = rows.next();
                    log.debug("Processing row {}", Arrays.asList(row));
                    try {
                        if (!this.isSkippedRow(params, columns, row)) {
                            batch.add(this.importAsset(request.getResourceResolver(), params, columns, row));
                        }
                    }
                    catch (FileNotFoundException e) {
                        failures.add(row[columns.get(params.getAbsTargetPathProperty()).getIndex()]);
                        log.error("Could not find file for row ", Arrays.asList(row), (Object)e);
                    }
                    catch (CsvAssetImportException e) {
                        failures.add(row[columns.get(params.getAbsTargetPathProperty()).getIndex()]);
                        log.error("Could not import the row due to ", (Object)e.getMessage(), (Object)e);
                    }
                    log.debug("Processed row {}", Arrays.asList(row));
                    if (batch.size() % params.getBatchSize() != 0) continue;
                    this.save(request.getResourceResolver(), batch.size());
                    result.addAll(batch);
                    batch.clear();
                    if (params.getThrottle() <= 0L) continue;
                    log.info("Throttling CSV Asset Importer batch processing for {} ms", (Object)params.getThrottle());
                    Thread.sleep(params.getThrottle());
                }
                this.save(request.getResourceResolver(), batch.size());
                result.addAll(batch);
                if (log.isInfoEnabled()) {
                    log.info("Imported as TOTAL of [ {} ] assets in {} ms", (Object)result.size(), (Object)(System.currentTimeMillis() - start));
                }
                try {
                    jsonResponse.put("assets", result);
                    jsonResponse.put("failures", failures);
                }
                catch (JSONException e) {
                    log.error("Could not serialized Excel Importer results into JSON", (Throwable)e);
                    this.addMessage(jsonResponse, "Could not serialized Excel Importer results into JSON");
                    response.setStatus(500);
                }
            }
            catch (RepositoryException e) {
                log.error("Could not save Assets to JCR", (Throwable)e);
                this.addMessage(jsonResponse, "Could not save assets. " + e.getMessage());
                response.setStatus(500);
            }
            catch (Exception e) {
                log.error("Could not process CSV import", (Throwable)e);
                this.addMessage(jsonResponse, "Could not process CSV import. " + e.getMessage());
                response.setStatus(500);
            }
        } else {
            log.error("Could not find CSV file in request.");
            this.addMessage(jsonResponse, "CSV file is missing");
            response.setStatus(500);
        }
        response.getWriter().print(jsonResponse.toString());
    }

    private Iterator<String[]> getRowsFromCsv(Parameters params) throws IOException {
        Csv csv = new Csv();
        InputStream is = params.getFile();
        if (params.getDelimiter() != null) {
            log.debug("Setting Field Delimiter to [ {} ]", (Object)params.getDelimiter());
            csv.setFieldDelimiter(params.getDelimiter().charValue());
        }
        if (params.getSeparator() != null) {
            log.debug("Setting Field Separator to [ {} ]", (Object)params.getSeparator());
            csv.setFieldSeparatorRead(params.getSeparator().charValue());
        }
        is = this.terminateLines(is, params.getSeparator() != null ? params.getSeparator().charValue() : csv.getFieldSeparatorRead(), params.getCharset());
        return csv.read(is, params.getCharset());
    }

    private String importAsset(ResourceResolver resourceResolver, Parameters params, Map<String, Column> columns, String[] row) throws FileNotFoundException, RepositoryException, PersistenceException, CsvAssetImportException {
        try {
            Asset asset = this.getOrCreateAsset(resourceResolver, params, columns, row);
            if (asset == null) {
                throw new CsvAssetImportException("Could not find an asset in the DAM to update. Skipping as a failure.");
            }
            log.debug("Imported asset: {}", (Object)asset.getPath());
            this.updateProperties(columns, row, params.getIgnoreProperties(), asset);
            log.debug("Updated properties on asset: {}", (Object)asset.getPath());
            return asset.getPath();
        }
        catch (Exception e) {
            throw new CsvAssetImportException("Could not import row", e);
        }
    }

    private void updateProperties(Map<String, Column> columns, String[] row, String[] ignoreProperties, Asset asset) throws RepositoryException, CsvAssetImportException {
        for (Map.Entry<String, Column> entry : columns.entrySet()) {
            if (ArrayUtils.contains((Object[])ignoreProperties, (Object)entry.getKey())) continue;
            if (StringUtils.isBlank((String)entry.getKey())) {
                log.warn("Found a blank property name for: {}", Arrays.asList(entry.getValue()));
                continue;
            }
            Column column = entry.getValue();
            String valueStr = row[column.getIndex()];
            Node metaProps = this.getMetadataProperties(asset, column.getRelPropertyPath());
            String propName = column.getPropertyName();
            if (StringUtils.isNotBlank((String)valueStr)) {
                Object val;
                Property prop;
                if (metaProps.hasProperty(propName) && ((prop = metaProps.getProperty(propName)).getType() != column.getJcrPropertyType() || column.isMulti() && !prop.isMultiple() || !column.isMulti() && prop.isMultiple())) {
                    prop.remove();
                }
                if (column.isMulti()) {
                    val = column.getMultiData(valueStr);
                    JcrUtil.setProperty((Node)metaProps, (String)propName, val);
                    log.debug("Setting multi property [ {} ~> {} ]", (Object)column.getRelPropertyPath(), Arrays.asList(column.getMultiData(valueStr)));
                    continue;
                }
                val = column.getData(valueStr);
                JcrUtil.setProperty((Node)metaProps, (String)propName, val);
                log.debug("Setting property [ {} ~> {} ]", (Object)column.getRelPropertyPath(), column.getData(valueStr));
                continue;
            }
            if (!metaProps.hasProperty(propName)) continue;
            metaProps.getProperty(propName).remove();
            log.debug("Removing property [ {} ]", (Object)column.getRelPropertyPath());
        }
    }

    private void updateSystemProperties(Asset asset) {
        Resource resource = (Resource)asset.adaptTo(Resource.class);
        Resource jcrContentResource = resource.getChild("jcr:content");
        if (jcrContentResource == null) {
            log.error("Could not find the jcr:content node for asset [ {} ]", (Object)asset.getPath());
            return;
        }
        ModifiableValueMap properties = (ModifiableValueMap)jcrContentResource.adaptTo(ModifiableValueMap.class);
        properties.put((Object)"cq:name", (Object)asset.getName());
        properties.put((Object)"cq:parentPath", (Object)StringUtils.removeEnd((String)asset.getPath(), (String)("/" + asset.getName())));
    }

    private Asset getOrCreateAsset(ResourceResolver resourceResolver, Parameters params, Map<String, Column> columns, String[] row) throws FileNotFoundException, RepositoryException, CsvAssetImportException {
        AssetManager assetManager = (AssetManager)resourceResolver.adaptTo(AssetManager.class);
        String uniqueId = null;
        if (StringUtils.isNotBlank((String)params.getUniqueProperty())) {
            uniqueId = row[columns.get(params.getUniqueProperty()).getIndex()];
        }
        String srcPath = null;
        if (StringUtils.isNotBlank((String)params.getFileLocation()) && !StringUtils.equals((String)"/dev/null", (String)params.getFileLocation()) && StringUtils.isNotBlank((String)params.getRelSrcPathProperty()) && StringUtils.isNotBlank((String)row[columns.get(params.getRelSrcPathProperty()).getIndex()])) {
            srcPath = params.getFileLocation() + "/" + row[columns.get(params.getRelSrcPathProperty()).getIndex()];
            log.debug("Row points to a file to import [ {} ]", (Object)srcPath);
        }
        String mimeType = this.getMimeType(params, columns, row);
        String absTargetPath = row[columns.get(params.getAbsTargetPathProperty()).getIndex()];
        if (StringUtils.endsWith((String)absTargetPath, (String)"/")) {
            throw new CsvAssetImportException("Absolute path [ " + absTargetPath + " ] is to a folder, not a file. Skipping");
        }
        Asset asset = null;
        if (StringUtils.isNotBlank((String)params.getUniqueProperty()) && StringUtils.isNotBlank((String)uniqueId)) {
            asset = this.findExistingAsset(resourceResolver, row[columns.get(params.getAbsTargetPathProperty()).getIndex()], params.getUniqueProperty(), uniqueId);
        } else {
            Resource assetResource = resourceResolver.getResource(absTargetPath);
            if (assetResource != null) {
                asset = DamUtil.resolveToAsset((Resource)assetResource);
            }
        }
        FileInputStream fileInputStream = null;
        if (srcPath != null) {
            fileInputStream = new FileInputStream(srcPath);
        }
        if (asset == null) {
            if (fileInputStream == null) {
                log.warn("Existing asset could not be found for [ {} ] and no src file can found to import", (Object)absTargetPath);
            } else {
                log.info("Existing asset could not be found for [ {} ], creating from [ {} ]", (Object)absTargetPath, (Object)srcPath);
                asset = this.createAsset(assetManager, absTargetPath, fileInputStream, mimeType);
            }
        } else if (Parameters.ImportStrategy.DELTA.equals((Object)params.getImportStrategy())) {
            if (!StringUtils.equals((String)asset.getPath(), (String)absTargetPath)) {
                Session session = (Session)resourceResolver.adaptTo(Session.class);
                if (!session.nodeExists(absTargetPath)) {
                    JcrUtils.getOrCreateByPath((String)StringUtils.substringBeforeLast((String)absTargetPath, (String)"/"), (String)"sling:OrderedFolder", (Session)session);
                }
                session.move(asset.getPath(), absTargetPath);
                log.info("Moved asset from [ {} ~> {} ]", (Object)asset.getPath(), (Object)absTargetPath);
                asset = DamUtil.resolveToAsset((Resource)resourceResolver.getResource(absTargetPath));
            }
            if (params.isUpdateBinary()) {
                if (fileInputStream != null) {
                    asset = this.updateAssetOriginal(asset, fileInputStream, mimeType);
                } else {
                    log.info("Delta import strategy with 'Update Binary' specified but no src was specified. Skipping updating of binary for [ {} ].", (Object)absTargetPath);
                }
            }
        } else if (Parameters.ImportStrategy.FULL.equals((Object)params.getImportStrategy())) {
            if (fileInputStream != null) {
                ((Node)((Resource)asset.adaptTo(Resource.class)).adaptTo(Node.class)).remove();
                log.info("Removed existing asset so it can be re-created");
                asset = this.createAsset(assetManager, absTargetPath, fileInputStream, mimeType);
            } else {
                log.info("Full import strategy specified but no src was specified. Skipping re-creation of binary for [ {} ].", (Object)absTargetPath);
            }
        }
        return asset;
    }

    private Asset updateAssetOriginal(Asset asset, InputStream fileInputStream, String mimeType) throws CsvAssetImportException {
        try {
            if (asset != null) {
                Node originalNode = (Node)asset.getOriginal().adaptTo(Node.class);
                if (originalNode != null) {
                    JcrUtils.putFile((Node)originalNode.getParent(), (String)"original", (String)mimeType, (InputStream)fileInputStream, (Calendar)Calendar.getInstance());
                    log.info("Updated existing Asset's [ {} ] original rendition.", (Object)asset.getPath());
                } else {
                    log.warn("Could not find original rendition for Asset [ {} ] to update.", (Object)asset.getPath());
                }
            } else {
                log.warn("Could not update a null asset");
            }
        }
        catch (Exception e) {
            throw new CsvAssetImportException("Could not update Asset at [ " + asset.getPath() + " ]", e);
        }
        return asset;
    }

    private Asset createAsset(AssetManager assetManager, String absTargetPath, InputStream fileInputStream, String mimeType) throws CsvAssetImportException {
        try {
            Asset asset = assetManager.createAsset(absTargetPath, fileInputStream, mimeType, true);
            log.info("Created new asset [ {} ]", (Object)absTargetPath);
            return asset;
        }
        catch (Exception e) {
            throw new CsvAssetImportException("Could not create Asset at [ " + absTargetPath + " ]", e);
        }
    }

    private String getMimeType(Parameters params, Map<String, Column> columns, String[] row) {
        String mimeType = "";
        Column mimeTypeCol = columns.get(params.getMimeTypeProperty());
        if (mimeTypeCol != null) {
            mimeType = row[columns.get(params.getMimeTypeProperty()).getIndex()];
        }
        if (mimeType.isEmpty() || TERMINATED.equals(mimeType)) {
            Column destColumn = columns.get(params.getAbsTargetPathProperty());
            String fileName = Text.getName((String)row[destColumn.getIndex()]);
            mimeType = this.mimeTypeService.getMimeType(fileName);
        }
        return mimeType;
    }

    private Asset findExistingAsset(ResourceResolver resourceResolver, String absTargetPath, String uniquePropertyName, String uniqueId) {
        ValueMap properties;
        String val;
        String absMetadataPath = absTargetPath + "/" + "jcr:content" + "/" + "metadata";
        Resource resource = resourceResolver.getResource(absMetadataPath);
        if (resource != null && StringUtils.equals((String)(val = (String)(properties = (ValueMap)resource.adaptTo(ValueMap.class)).get(uniquePropertyName, String.class)), (String)uniqueId)) {
            log.debug("Found Asset at [ {} ] with matching unique property value of [ {} ]", (Object)resource.getPath(), (Object)uniqueId);
            return DamUtil.resolveToAsset((Resource)resource);
        }
        Iterator resourceIterator = resourceResolver.findResources("SELECT * FROM [dam:AssetContent] WHERE [metadata/" + uniquePropertyName + "] = '" + uniqueId + "'", "JCR-SQL2");
        if (resourceIterator.hasNext()) {
            return DamUtil.resolveToAsset((Resource)((Resource)resourceIterator.next()));
        }
        return null;
    }

    private InputStream terminateLines(InputStream is, char separator, String charset) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(baos);
        LineIterator lineIterator = IOUtils.lineIterator((InputStream)is, (String)charset);
        while (lineIterator.hasNext()) {
            String line = StringUtils.stripToNull((String)lineIterator.next());
            if (line == null) continue;
            line = line + separator + TERMINATED;
            printStream.println(line);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private void save(ResourceResolver resourceResolver, int size) throws PersistenceException {
        if (resourceResolver.hasChanges()) {
            long start = System.currentTimeMillis();
            resourceResolver.commit();
            if (log.isInfoEnabled()) {
                log.info("Imported a BATCH of [ {} ] assets in {} ms", (Object)size, (Object)(System.currentTimeMillis() - start));
            }
        } else {
            log.debug("Nothing to save");
        }
    }

    private Node getMetadataProperties(Asset asset, String relPropertyPath) throws RepositoryException, CsvAssetImportException {
        String metadataResourcePath = "jcr:content/metadata";
        Resource assetResource = (Resource)asset.adaptTo(Resource.class);
        Resource metadataResource = assetResource.getChild(metadataResourcePath);
        if (metadataResource == null) {
            throw new CsvAssetImportException("Could not find metadata resource at [ " + assetResource.getPath() + "/" + metadataResourcePath + " ]. This is very strange. Skipping row as failure however some dam:Asset nodes for this asset may have been created.");
        }
        if (!StringUtils.contains((String)relPropertyPath, (String)"/")) {
            return (Node)metadataResource.adaptTo(Node.class);
        }
        ResourceResolver resourceResolver = assetResource.getResourceResolver();
        String relPropertyPathPrefix = StringUtils.substringBeforeLast((String)relPropertyPath, (String)"/");
        String canonicalPath = com.day.text.Text.makeCanonicalPath((String)(metadataResource.getPath() + "/" + relPropertyPathPrefix));
        Node node = JcrUtils.getOrCreateByPath((String)canonicalPath, (String)"nt:unstructured", (Session)((Session)resourceResolver.adaptTo(Session.class)));
        Resource relativeResource = resourceResolver.getResource(node.getPath());
        return (Node)relativeResource.adaptTo(Node.class);
    }

    private boolean isSkippedRow(Parameters params, Map<String, Column> columns, String[] row) {
        if (StringUtils.isNotBlank((String)params.getSkipProperty())) {
            Column column = columns.get(params.getSkipProperty());
            if (column != null) {
                String value = StringUtils.stripToNull((String)row[column.getIndex()]);
                return StringUtils.equalsIgnoreCase((String)Boolean.TRUE.toString(), (String)value);
            }
            log.warn("Could not find the Skip column at key [ {} ]", (Object)params.getSkipProperty());
        }
        return false;
    }

    private void addMessage(JSONObject jsonObject, String message) {
        try {
            jsonObject.put("message", (Object)message);
        }
        catch (JSONException e) {
            log.error("Could not formulate JSON Response", (Throwable)e);
        }
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }
}

