/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.csv_asset_importer.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;

public class Parameters {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final long DEFAULT_THROTTLE = 0L;
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private String uniqueProperty;
    private String relSrcPathProperty;
    private String absTargetPathProperty;
    private String mimeTypeProperty;
    private String skipProperty;
    private String multiDelimiter;
    private String fileLocation;
    private String[] ignoreProperties;
    private ImportStrategy importStrategy;
    private Character separator;
    private Character delimiter = null;
    private String charset = "UTF-8";
    private InputStream file;
    private Long throttle = 0L;
    private int batchSize = 1000;
    private boolean updateBinary = false;

    public Parameters(SlingHttpServletRequest request) throws IOException {
        RequestParameter charsetParam = request.getRequestParameter("charset");
        RequestParameter delimiterParam = request.getRequestParameter("delimiter");
        RequestParameter fileParam = request.getRequestParameter("file");
        RequestParameter multiDelimiterParam = request.getRequestParameter("multiDelimiter");
        RequestParameter separatorParam = request.getRequestParameter("separator");
        RequestParameter fileLocationParam = request.getRequestParameter("fileLocation");
        RequestParameter importStrategyParam = request.getRequestParameter("importStrategy");
        RequestParameter updateBinaryParam = request.getRequestParameter("updateBinary");
        RequestParameter mimeTypePropertyParam = request.getRequestParameter("mimeTypeProperty");
        RequestParameter skipPropertyParam = request.getRequestParameter("skipProperty");
        RequestParameter absTargetPathPropertyParam = request.getRequestParameter("absTargetPathProperty");
        RequestParameter relSrcPathPropertyParam = request.getRequestParameter("relSrcPathProperty");
        RequestParameter uniquePropertyParam = request.getRequestParameter("uniqueProperty");
        RequestParameter ignorePropertiesParam = request.getRequestParameter("ignoreProperties");
        RequestParameter throttleParam = request.getRequestParameter("throttle");
        RequestParameter batchSizeParam = request.getRequestParameter("batchSize");
        this.charset = DEFAULT_CHARSET;
        if (charsetParam != null) {
            this.charset = StringUtils.defaultIfEmpty((String)charsetParam.toString(), (String)DEFAULT_CHARSET);
        }
        this.delimiter = null;
        if (delimiterParam != null && StringUtils.isNotBlank((String)delimiterParam.toString())) {
            this.delimiter = Character.valueOf(delimiterParam.toString().charAt(0));
        }
        this.separator = null;
        if (separatorParam != null && StringUtils.isNotBlank((String)separatorParam.toString())) {
            this.separator = Character.valueOf(separatorParam.toString().charAt(0));
        }
        this.multiDelimiter = "|";
        if (multiDelimiterParam != null && StringUtils.isNotBlank((String)multiDelimiterParam.toString())) {
            this.multiDelimiter = multiDelimiterParam.toString();
        }
        this.importStrategy = ImportStrategy.FULL;
        if (importStrategyParam != null && StringUtils.isNotBlank((String)importStrategyParam.toString())) {
            this.importStrategy = ImportStrategy.valueOf(importStrategyParam.toString());
        }
        this.updateBinary = false;
        if (updateBinaryParam != null && StringUtils.isNotBlank((String)updateBinaryParam.toString())) {
            this.updateBinary = StringUtils.equalsIgnoreCase((String)updateBinaryParam.toString(), (String)"true");
        }
        this.fileLocation = "/dev/null";
        if (fileLocationParam != null && StringUtils.isNotBlank((String)fileLocationParam.toString())) {
            this.fileLocation = fileLocationParam.toString();
        }
        this.skipProperty = null;
        if (skipPropertyParam != null && StringUtils.isNotBlank((String)skipPropertyParam.toString())) {
            this.skipProperty = StringUtils.stripToNull((String)skipPropertyParam.toString());
        }
        this.mimeTypeProperty = null;
        if (mimeTypePropertyParam != null && StringUtils.isNotBlank((String)mimeTypePropertyParam.toString())) {
            this.mimeTypeProperty = StringUtils.stripToNull((String)mimeTypePropertyParam.toString());
        }
        this.absTargetPathProperty = null;
        if (absTargetPathPropertyParam != null && StringUtils.isNotBlank((String)absTargetPathPropertyParam.toString())) {
            this.absTargetPathProperty = StringUtils.stripToNull((String)absTargetPathPropertyParam.toString());
        }
        this.relSrcPathProperty = null;
        if (relSrcPathPropertyParam != null && StringUtils.isNotBlank((String)relSrcPathPropertyParam.toString())) {
            this.relSrcPathProperty = StringUtils.stripToNull((String)relSrcPathPropertyParam.toString());
        }
        this.uniqueProperty = null;
        if (uniquePropertyParam != null && StringUtils.isNotBlank((String)uniquePropertyParam.toString())) {
            this.uniqueProperty = StringUtils.stripToNull((String)uniquePropertyParam.toString());
        }
        this.ignoreProperties = new String[]{"_LINE_TERMINATED"};
        if (ignorePropertiesParam != null && StringUtils.isNotBlank((String)ignorePropertiesParam.toString())) {
            String[] tmp = StringUtils.split((String)StringUtils.stripToNull((String)ignorePropertiesParam.toString()), (String)",");
            ArrayList<String> list = new ArrayList<String>();
            for (String t : tmp) {
                String val = StringUtils.stripToNull((String)t);
                if (val == null) continue;
                list.add(val);
            }
            list.add("_LINE_TERMINATED");
            this.ignoreProperties = list.toArray(new String[0]);
        }
        if (fileParam != null && fileParam.getInputStream() != null) {
            this.file = fileParam.getInputStream();
        }
        this.throttle = 0L;
        if (throttleParam != null && StringUtils.isNotBlank((String)throttleParam.toString())) {
            try {
                this.throttle = Long.valueOf(throttleParam.toString());
                if (this.throttle < 0L) {
                    this.throttle = 0L;
                }
            }
            catch (Exception e) {
                this.throttle = 0L;
            }
        }
        this.batchSize = 1000;
        if (batchSizeParam != null && StringUtils.isNotBlank((String)batchSizeParam.toString())) {
            try {
                this.batchSize = Integer.valueOf(batchSizeParam.toString());
                if (this.batchSize < 1) {
                    this.batchSize = 1000;
                }
            }
            catch (Exception e) {
                this.batchSize = 1000;
            }
        }
    }

    public final String getUniqueProperty() {
        return this.uniqueProperty;
    }

    public final String getRelSrcPathProperty() {
        return this.relSrcPathProperty;
    }

    public final String getAbsTargetPathProperty() {
        return this.absTargetPathProperty;
    }

    public final String getMimeTypeProperty() {
        return this.mimeTypeProperty;
    }

    public final String getSkipProperty() {
        return this.skipProperty;
    }

    public final String getFileLocation() {
        return this.fileLocation;
    }

    public final ImportStrategy getImportStrategy() {
        return this.importStrategy;
    }

    public final Character getSeparator() {
        return this.separator;
    }

    public final Character getDelimiter() {
        return this.delimiter;
    }

    public final String getCharset() {
        return this.charset;
    }

    public final InputStream getFile() {
        return this.file;
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    public final String getMultiDelimiter() {
        return this.multiDelimiter;
    }

    public final String[] getIgnoreProperties() {
        return this.ignoreProperties;
    }

    public final long getThrottle() {
        return this.throttle;
    }

    public boolean isUpdateBinary() {
        return this.updateBinary;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println();
        pw.println("CSV Asset Importer Config");
        pw.println("----------------------------------------");
        pw.println("File Provided: " + String.valueOf(this.getFile() != null));
        pw.println("Import Strategy: " + (Object)((Object)this.getImportStrategy()));
        if (ImportStrategy.DELTA.equals((Object)this.getImportStrategy())) {
            pw.println("Update Binary: " + this.isUpdateBinary());
        }
        pw.println("File Location: " + this.getFileLocation());
        pw.println("Unique Property: " + this.getUniqueProperty());
        pw.println("Absolute Target Path Property: " + this.getAbsTargetPathProperty());
        pw.println("Relative Src Path Property: " + this.getRelSrcPathProperty());
        pw.println("MIME Type Property: " + this.getMimeTypeProperty());
        pw.println("Skip Property: " + this.getSkipProperty());
        pw.println("Ignore Properties: " + Arrays.asList(this.getIgnoreProperties()));
        pw.println("Batch Size: " + this.getBatchSize());
        pw.println("Throttle: " + this.getThrottle());
        pw.println("Charset: " + this.getCharset());
        pw.println("Delimiter: " + this.getDelimiter());
        pw.println("Separator: " + this.getSeparator());
        return sw.toString();
    }

    public static enum ImportStrategy {
        FULL,
        DELTA;

    }
}

